<?php 
include 'enableCORS.php';
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Cls_exp_pdf extends CI_Controller {

	Public function __construct(){
        enableCORS(); 
		parent::__construct();
		/* CARGAMOS LIBRERIAS PARA ESTE CONTROLLER*/       		
		include(dirname(__FILE__)."/../libraries/MPDF54/mpdf.php");

		$this->load->model(array('mdl_exp_exc')); 
	}

	/*SOLICITUD*/
    public function fnc_imp_sol_pdf()
    {
        /*[AUT-20190702 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);   

        /*[AUT-20190702 : Parametros de Entrada desde ExtJS]*/
        $iCodSpt = $data[0];
 
        $solicitud = $this->mdl_exp_exc->mdl_csu_sol_pet($iCodSpt,'','',0,0,0,'0',0,0,'','',0,0,0);      
        
        /*Insertamos el logo de la empresa*/        
        $img_log_goo = dirname(__FILE__).'/../../contents/logo.jpeg';       
            
        /*Abrimos la plantilla*/
        $extmod_str=implode("",file(dirname(__FILE__).'/../../contents/htm-ntf-sol-pet.htm'));        
    
        foreach ($solicitud as $spt)
        {            
        	$extmod_str=str_replace('@@fec-sys', $spt->tmp_fec_sys, $extmod_str);
            $extmod_str=str_replace('@@cod-spt', $spt->tsp_cod_spt, $extmod_str);
            $extmod_str=str_replace('@@emo-por', $spt->tmp_emi_por, $extmod_str);
            $extmod_str=str_replace('@@sol-por', $spt->tmp_sol_por, $extmod_str);
            $extmod_str=str_replace('@@fec-emi', $spt->mtx_fec_emi, $extmod_str);
            $extmod_str=str_replace('@@des-est', $spt->tes_des_ess, $extmod_str);
            $extmod_str=str_replace('@@fec-etm', $spt->mtx_fec_etm, $extmod_str);
            $extmod_str=str_replace('@@rzn-scl', $spt->tsp_rzn_scl, $extmod_str);
            $extmod_str=str_replace('@@des-npr', $spt->tnp_des_npr, $extmod_str);
            $extmod_str=str_replace('@@vbo-sub', $spt->tmp_vbo_sup, $extmod_str);
            $extmod_str=str_replace('@@des-rbr', $spt->tmr_des_rbr, $extmod_str);
            $extmod_str=str_replace('@@vbo-rbr', $spt->tmp_vbo_rbr, $extmod_str);
            $extmod_str=str_replace('@@asu-sol', $spt->tsp_asu_sol, $extmod_str);
            $extmod_str=str_replace('@@obs-sol', $spt->tsp_obs_sol, $extmod_str);

            $extmod_str=str_replace('@@tip-mon', $spt->ttg_des_gnr, $extmod_str);
            $extmod_str=str_replace('@@val-sol', number_format((float)$spt->tsp_mnt_pri, 2,',','.'), $extmod_str);             
        }

         $firma = $this
        ->mdl_exp_exc
        ->mdl_csu_apb_sol(0,$iCodSpt,0);

       
        $cnt_fir = 0;
        foreach ($firma as $fir)   
        {          
            if  ($fir->tap_est_apb === '1'){

                $extmod_str_apb= '
                    <td valign="center" colspan="1" style="background-color: rgb(219, 229, 241); text-align:left; height: 20px; text-align: center;">
                        <span style="font-size:11px;"><span style="font-family: tahoma,geneva,sans-serif;"><b>&nbsp;'.$fir->tmu_nom_usr.'</b></span></span>
                    </td>';     

                if  ($fir->tmu_rta_fir <> ''){

                    $extmod_str_fir= '
                        <td valign="center" colspan="1" style="padding: 0 0 5px 0; background-color: rgb(255, 255, 255); height: 100px;  text-align: center;" valign="bottom">
                            <span style="font-size:10px;"><span style="font-family: tahoma,geneva,sans-serif;"><IMG SRC="' . APPPATH . '../../archivos/arc_doc_mae_usr/' . $fir->tmu_rta_fir . '" WIDTH=200 HEIGHT=200 BORDER=0 ></span></span>
                        </td>';

                }else{

                    $extmod_str_fir= '
                        <td valign="center" colspan="1" style="padding: 0 0 5px 0; background-color: rgb(255, 255, 255); height: 100px;  text-align: center;" valign="bottom">
                            <span style="font-size:10px;"><span style="font-family: tahoma,geneva,sans-serif;"><IMG SRC="' . APPPATH . '../../images/firma.jpg" WIDTH=200 HEIGHT=200 BORDER=0 ></span></span>
                        </td>';

                }

                $adj_apb = $adj_apb . $extmod_str_apb;
                $adj_fir = $adj_fir . $extmod_str_fir;

                $cnt_fir+= 1;
            }            
        }    
        
        if($cnt_fir > 0 && ($spt->tes_cod_ess === '101' || $spt->tes_cod_ess === '106')){
            
            $extmod_str=str_replace('@@aprobadores', '<tr>'.$adj_apb.'</tr><tr>'.$adj_fir.'</tr>', $extmod_str);
        }
        else{
            
            $adj_apb= '
                <td valign="center" colspan="1" style="background-color: rgb(219, 229, 241); text-align:left; height: 20px; text-align: center;">
                    <span style="font-size:11px;"><span style="font-family: tahoma,geneva,sans-serif;"><b>&nbsp;Sin aprobadores</b></span></span>
                </td>';
                
            $adj_fir= '
                <td valign="center" colspan="1" style="padding: 0 0 5px 0; background-color: rgb(255, 255, 255); height: 100px;  text-align: center;" valign="bottom">
                    <span style="font-size:10px;"><span style="font-family: tahoma,geneva,sans-serif;">&nbsp;No Firmar</span></span>
                </td>';
            
            $extmod_str=str_replace('@@aprobadores', '<tr>'.$adj_apb.'</tr><tr>'.$adj_fir.'</tr>', $extmod_str);
        }

        /*IMAGENES*/
        $extmod_str=str_replace('@@img-log-goo', $img_log_goo, $extmod_str);          

        //configuramos PDF
        $mpdf= new mPDF(
                        '',    // mode - default ''
                        'LETTER',    // format - A4, for example, default ''
                        0,     // font size - default 0
                        '',    // default font family
                        15,    // margin_left
                        15,    // margin right
                        16,    // margin top
                        16,    // margin bottom
                        9,     // margin header
                        9,     // margin footer
                        'L'    // L - landscape, P - portrait
                        );

        $mpdf->SetHTMLFooter('<hr align="center"; width="100% "; noshade; color=#9F9F9F>
        						<table width="100%" style="vertical-align: bottom; font-family: tahoma,geneva,sans-serif; font-size: 8pt; color: #9F9F9F; ">
        								<tr> 
        									<!--<td width="50%" style="text-align: left;">Solicitud</td> -->
        									<td width="50%" align="center";>{PAGENO}/{nbpg}</td> 
        								</tr>
        						</table>');    
       
       $mpdf->WriteHTML($extmod_str);        

       $mpdf->Output("SOLICITUD_" . $iCodSpt . ".pdf", "I");       
    }

    /*RENDICION*/
    public function fnc_imp_rin_pdf()
    {
        /*[AUT-20190805 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);   

        /*[AUT-20190805 : Parametros de Entrada desde ExtJS]*/
        $iCodRgs = $data[0];
 
        $rendicion = $this->mdl_exp_exc->mdl_csu_rin_gst($iCodRgs,
                                                         0,
                                                         '',
                                                         '',
                                                         0,
                                                         0,
                                                         0,
                                                         '',
														 '0');     
        
        /*Insertamos el logo de la empresa*/        
        $img_log_goo = dirname(__FILE__).'/../../contents/logo.jpeg';       
            
        /*Abrimos la plantilla*/
        $extmod_str=implode("",file(dirname(__FILE__).'/../../contents/htm-ntf-rin-gst.htm'));   
        $extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/htm-ntf-rin-gst-det.htm'));     
    
        foreach ($rendicion as $rin)
        {            
            $extmod_str=str_replace('@@fec-sys', $rin->tmp_fec_sys, $extmod_str);

            $extmod_str=str_replace('@@cod-rgs', $rin->trg_cod_rgs, $extmod_str);
            $extmod_str=str_replace('@@emo-por', $rin->tmp_emi_por, $extmod_str);
            //$extmod_str=str_replace('@@fec-rin', $rin->mtx_fec_rgs, $extmod_str);
            $extmod_str=str_replace('@@fec-rin', ($rin->mtx_fec_rgs <> '00/00/0000' ? $rin->mtx_fec_rgs : ''), $extmod_str);
            $extmod_str=str_replace('@@idd-rgs', $rin->trg_idd_rgs, $extmod_str);            
            $extmod_str=str_replace('@@ped-ctb', $rin->trg_ped_ctb, $extmod_str);
            $extmod_str=str_replace('@@apr-rgs', $rin->tmp_apr_rgs, $extmod_str);
            $extmod_str=str_replace('@@des-rgs', $rin->ter_des_rgs, $extmod_str);


                $fondo = $this->mdl_exp_exc->mdl_csu_fon_fij($rin->tff_cod_ffj,
                                                             '',
                                                             '',
                                                             0,
                                                             0,
                                                             '0',
                                                             0,
                                                             '',
                                                             '',
                                                             '',
                                                             '',
                                                             0); 

                foreach ($fondo as $fnd) {
                    # code...

                    $extmod_str=str_replace('@@rzn_scl', $fnd->tsp_rzn_scl, $extmod_str);
                    $extmod_str=str_replace('@@rsp_ffj', $fnd->tmp_rsp_ffj, $extmod_str);
                    $extmod_str=str_replace('@@des_trp', $fnd->ttr_des_trp, $extmod_str);
                    $extmod_str=str_replace('@@des_tct', $fnd->ttc_des_tct, $extmod_str);
                    $extmod_str=str_replace('@@des_bco', $fnd->tmb_des_bco, $extmod_str);
                    $extmod_str=str_replace('@@num_cta', $fnd->tff_num_cta, $extmod_str);
                    $extmod_str=str_replace('@@rut-ffj', $fnd->tff_rut_ffj . '-' . $fnd->tff_dvf_ffj, $extmod_str);
                    $extmod_str=str_replace('@@rzn-ffj', $fnd->tff_rzn_scl, $extmod_str);
                    $extmod_str=str_replace('@@tot_ffj', number_format((float)$fnd->tff_mto_ffj, 2,',','.'), $extmod_str);             

                }

                $rin_gst = $this->mdl_exp_exc->mdl_csu_rin_reg_gst(2,
                                                                     $rin->trg_cod_rgs,
                                                                     '',
                                                                     0);

                foreach ($rin_gst as $gst) {
                    # code...                  
                                       
                    $extmod_str_det=str_replace('@@fec_gst', ($gst->mtx_fec_gst <> '00/00/0000' ? $gst->mtx_fec_gst : ''), $extmod_str_det);
                    $extmod_str_det=str_replace('@@des_cgt', $gst->tcg_des_cgt, $extmod_str_det);                    
                    $extmod_str_det=str_replace('@@ref_gst', $gst->tmp_des_ref, $extmod_str_det);   
                    $extmod_str_det=str_replace('@@pln_cta', $gst->tmp_nom_cta, $extmod_str_det);                                        
                    $extmod_str_det=str_replace('@@nom_prv', $gst->tmp_nom_prv, $extmod_str_det);                    
                    $extmod_str_det=str_replace('@@emp_sdp', $gst->tsp_nom_fan, $extmod_str_det); 
                    $extmod_str_det=str_replace('@@des_tdo', $gst->ttc_des_tdc, $extmod_str_det);                   
                    $extmod_str_det=str_replace('@@num_doc', $gst->trg_num_doc, $extmod_str_det);                    
                    $extmod_str_det=str_replace('@@mto_gst', number_format((float)$gst->trg_mto_gst, 2,',','.'), $extmod_str_det); 

                    $det_rin_gst.= $extmod_str_det;                                    
                    
                    $extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/htm-ntf-rin-gst-det.htm')); 
                        
                }                

            $extmod_str=str_replace('@@tot-gst', number_format((float)$rin->trg_mto_rgs, 2,',','.'), $extmod_str);
            $extmod_str=str_replace('@@por-rin', number_format((float)$fnd->tff_mto_ffj - $rin->trg_mto_rgs, 2,',','.'), $extmod_str);
        }


        $firma = $this
        ->mdl_exp_exc
        ->mdl_csu_apb_rgs(0,$iCodRgs,0);

        $cnt_fir = 0;
        foreach ($firma as $fir)   
        {         
            if  ($fir->tar_est_apb === '1'){

                $extmod_str_apb= '
                <td valign="center" colspan="1" style="background-color: rgb(219, 229, 241); text-align:left; height: 20px; text-align: center;">
                    <span style="font-size:11px;"><span style="font-family: tahoma,geneva,sans-serif;"><b>&nbsp;' . $fir->tmu_nom_usr . '</b></span></span>
                </td>';

                if  ($fir->tmu_rta_fir <> ''){

                    $extmod_str_fir= '
                        <td valign="center" colspan="1" style="padding: 0 0 5px 0; background-color: rgb(255, 255, 255); height: 100px;  text-align: center;" valign="bottom">
                            <span style="font-size:10px;"><span style="font-family: tahoma,geneva,sans-serif;"><IMG SRC="' . APPPATH . '../../archivos/arc_doc_mae_usr/' . $fir->tmu_rta_fir . '" WIDTH=200 HEIGHT=200 BORDER=0 ></span></span>
                        </td>';

                }else{

                    $extmod_str_fir= '
                        <td valign="center" colspan="1" style="padding: 0 0 5px 0; background-color: rgb(255, 255, 255); height: 100px;  text-align: center;" valign="bottom">
                            <span style="font-size:10px;"><span style="font-family: tahoma,geneva,sans-serif;"><IMG SRC="' . APPPATH . '../../images/firma.jpg" WIDTH=200 HEIGHT=200 BORDER=0 ></span></span>
                        </td>';

                }

                $adj_apb = $adj_apb . $extmod_str_apb;
                $adj_fir = $adj_fir . $extmod_str_fir;

                $cnt_fir+= 1;  
            }            
        }                
       
        if($cnt_fir > 0 && $rin->ter_cod_rgs === '101'){
            
            $extmod_str=str_replace('@@aprobadores', '<tr>'.$adj_apb.'</tr><tr>'.$adj_fir.'</tr>', $extmod_str);
        }
        else{
            
            $adj_apb= '
                <td valign="center" colspan="1" style="background-color: rgb(219, 229, 241); text-align:left; height: 20px; text-align: center;">
                    <span style="font-size:11px;"><span style="font-family: tahoma,geneva,sans-serif;"><b>&nbsp;Sin aprobadores</b></span></span>
                </td>';
                
            $adj_fir= '
                <td valign="center" colspan="1" style="padding: 0 0 5px 0; background-color: rgb(255, 255, 255); height: 100px;  text-align: center;" valign="bottom">
                    <span style="font-size:10px;"><span style="font-family: tahoma,geneva,sans-serif;">&nbsp;No Firmar</span></span>
                </td>';
            
            $extmod_str=str_replace('@@aprobadores', '<tr>'.$adj_apb.'</tr><tr>'.$adj_fir.'</tr>', $extmod_str);
        }

        $extmod_str=str_replace('@@htm-ntf-rin-gst-det', $det_rin_gst, $extmod_str);

        /*IMAGENES*/
        $extmod_str=str_replace('@@img-log-goo', $img_log_goo, $extmod_str);  

        //configuramos PDF
        $mpdf= new mPDF(
                        '',    // mode - default ''
                        //'LETTER',    // format - A4, for example, default ''
                        'LETTER-L',    // format - A4, for example, default ''
                        0,     // font size - default 0
                        '',    // default font family
                        2,    // margin_left
                        2,    // margin right
                        5,    // margin top
                        15,    // margin bottom
                        9,     // margin header
                        0,     // margin footer
                        'L'    // L - landscape, P - portrait
                        );


        $mpdf->SetHTMLFooter('<hr align="center"; width="100% "; noshade; color=#9F9F9F>
                                <table width="100%" style="vertical-align: bottom; font-family: tahoma,geneva,sans-serif; font-size: 8pt; color: #9F9F9F; ">
                                        <tr>                                            
                                            <td width="50%" align="center";>{PAGENO}/{nbpg}</td> 
                                        </tr>
                                </table>');    
       
        $mpdf->WriteHTML($extmod_str);        

        $mpdf->Output("RENDICION" . $iCodRgs . ".pdf", "I");       
    }  

    /*DEPOSITO A PLAZO*/
    public function fnc_imp_dps_plz()
    {
        /*[AUT-20190822 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);   

        /*[AUT-20190822 : Parametros de Entrada desde ExtJS]*/
        $iCodDpz = $data[0];
 
        $deposito = $this->mdl_exp_exc->mdl_csu_dps_pzo($iCodDpz,
                                                        '',
                                                        '',
                                                        0,
                                                        0,
                                                        '0',
                                                        0); 
        
        /*Insertamos el logo de la empresa*/        
        $img_log_goo = dirname(__FILE__).'/../../contents/logo.jpeg';       
            
        /*Abrimos la plantilla*/
        $extmod_str=implode("",file(dirname(__FILE__).'/../../contents/htm-imp-dps-pzo.htm'));
        $extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/htm-imp-det-dps-pzo.htm'));        
    
        foreach ($deposito as $dps)
        {            
            $extmod_str=str_replace('@@fec-sys', $dps->tmp_fec_sys, $extmod_str);
            $extmod_str=str_replace('@@num-dps', $dps->tdp_cod_dpz, $extmod_str);

            $extmod_str=str_replace('@@rzn-scl', $dps->tsp_rzn_scl, $extmod_str);
            $extmod_str=str_replace('@@emo-por', $dps->tmp_emi_por, $extmod_str);
            $extmod_str=str_replace('@@atz-por', $dps->tmp_aut_por, $extmod_str);
            $extmod_str=str_replace('@@des-dps', $dps->ttd_des_dps, $extmod_str);            
            $extmod_str=str_replace('@@fol-dap', $dps->tdp_fol_dap, $extmod_str);
            $extmod_str=str_replace('@@fec-inv', fcf_cmb_fec($dps->tdp_fec_inv_inv), $extmod_str);
            $extmod_str=str_replace('@@mnt-inv', number_format((float)$dps->tdp_mnt_inv_inv, 0,',','.'), $extmod_str);
            $extmod_str=str_replace('@@fec-rsc', fcf_cmb_fec($dps->tdp_fec_rsc_inv), $extmod_str);
            $extmod_str=str_replace('@@mnt-rsc', number_format((float)$dps->tdp_mnt_rsc_inv, 0,',','.'), $extmod_str);
            $extmod_str=str_replace('@@mon-org', $dps->ttg_des_gnr, $extmod_str);            
            $extmod_str=str_replace('@@val-cmb', number_format((float)$dps->tdp_val_cmb_inv, 2,',','.'), $extmod_str);
            $extmod_str=str_replace('@@plz-dia', $dps->tdp_plz_dia_inv, $extmod_str);
            $extmod_str=str_replace('@@dia-bse', $dps->tdp_dia_bse_inv . ' - '  . $dps->ttb_des_bse_inv, $extmod_str);
            $extmod_str=str_replace('@@tas-bse', number_format((float)$dps->tdp_tas_bse_inv, 2,',','.'), $extmod_str);
            $extmod_str=str_replace('@@tas-ped', number_format((float)$dps->tdp_tas_ped_inv, 6,',','.'), $extmod_str);            
            $extmod_str=str_replace('@@bco-inv', $dps->tmp_bco_inv, $extmod_str);
            $extmod_str=str_replace('@@bco-rsc', $dps->tmp_bco_rsc, $extmod_str); 
            $extmod_str=str_replace('@@mnt-gnc', number_format((float)$dps->tdp_mnt_gnc_inv, 0,',','.'), $extmod_str);           
            $extmod_str=str_replace('@@obs-dpz', $dps->tdp_obs_dpz, $extmod_str);

            $detalle =  $this
                    ->mdl_exp_exc
                    ->mdl_csu_det_inv(0,
                                      $iCodDpz);

            foreach ($detalle as $det)
            {
                $extmod_str_det=str_replace('@@tdi_fec_inv', $det->mtx_fec_pgo, $extmod_str_det);
                $extmod_str_det=str_replace('@@tdi_cme_ddp', $det->tdi_cme_ddp, $extmod_str_det);                
                $extmod_str_det=str_replace('@@tdi_mto_pes', number_format((float)$det->tdi_mto_pes, 0,',','.'), $extmod_str_det);            
                $extmod_str_det=str_replace('@@tdi_tpo_mov', $det->tdi_tpo_mov, $extmod_str_det);
                $extmod_str_det=str_replace('@@tdi_rge_flu', $det->trf_des_rfl, $extmod_str_det);
                $extmod_str_det=str_replace('@@tdi_mir_est', $det->tae_des_aeg, $extmod_str_det);

                $adj_det_inv.= $extmod_str_det;
                $extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/htm-imp-det-dps-pzo.htm'));        
            }       

        }

        $extmod_str=str_replace('@@det_flu_inv', $adj_det_inv, $extmod_str); 

        $firma = $this
        ->mdl_exp_exc
        ->mdl_csu_apb_dpz(0,$iCodDpz,0);
        
        $cnt_fir = 0;
        foreach ($firma as $fir)   
        {             
            if  ($fir->tad_est_apb === '1'){ // Si se encuantra aprobado

                 $extmod_str_apb= '
                    <td valign="center" colspan="1" style="background-color: rgb(219, 229, 241); text-align:left; height: 20px; text-align: center;">
                        <span style="font-size:11px;"><span style="font-family: tahoma,geneva,sans-serif;"><b>&nbsp;' . $fir->tmu_nom_usr . '</b></span></span>
                    </td>';

                if  ($fir->tmu_rta_fir <> ''){
                    $extmod_str_fir= '
                        <td valign="center" colspan="1" style="padding: 0 0 5px 0; background-color: rgb(255, 255, 255); height: 100px;  text-align: center;" valign="bottom">
                            <span style="font-size:10px;"><span style="font-family: tahoma,geneva,sans-serif;"><IMG SRC="' . APPPATH . '../../archivos/arc_doc_mae_usr/' . $fir->tmu_rta_fir . '" WIDTH=200 HEIGHT=200 BORDER=0 ></span></span>
                        </td>';

                }else{
                    $extmod_str_fir= '
                        <td valign="center" colspan="1" style="padding: 0 0 5px 0; background-color: rgb(255, 255, 255); height: 100px;  text-align: center;" valign="bottom">
                            <span style="font-size:10px;"><span style="font-family: tahoma,geneva,sans-serif;"><IMG SRC="' . APPPATH . '../../images/firma.jpg" WIDTH=200 HEIGHT=200 BORDER=0 ></span></span>
                        </td>';
                }

                $adj_apb = $adj_apb . $extmod_str_apb;
                $adj_fir = $adj_fir . $extmod_str_fir;

                $cnt_fir+= 1; 

            }            
        }                
       
        if($cnt_fir > 0 && ($dps->tei_cod_inv === '101' || $dps->tei_cod_inv === '106' || $dps->tei_cod_inv === '107')){
            
            $extmod_str=str_replace('@@aprobadores', '<tr>'.$adj_apb.'</tr><tr>'.$adj_fir.'</tr>', $extmod_str);
        }
        else{
            
            $adj_apb= '
                <td valign="center" colspan="1" style="background-color: rgb(219, 229, 241); text-align:left; height: 20px; text-align: center;">
                    <span style="font-size:11px;"><span style="font-family: tahoma,geneva,sans-serif;"><b>&nbsp;Sin aprobadores</b></span></span>
                </td>';
                
            $adj_fir= '
                <td valign="center" colspan="1" style="padding: 0 0 5px 0; background-color: rgb(255, 255, 255); height: 100px;  text-align: center;" valign="bottom">
                    <span style="font-size:10px;"><span style="font-family: tahoma,geneva,sans-serif;">&nbsp;No Firmar</span></span>
                </td>';
            
            $extmod_str=str_replace('@@aprobadores', '<tr>'.$adj_apb.'</tr><tr>'.$adj_fir.'</tr>', $extmod_str);
        }

        /*IMAGENES*/                
        $extmod_str=str_replace('@@img-log-goo', $img_log_goo, $extmod_str);  
        

        //configuramos PDF
        $mpdf= new mPDF(
                        '',    // mode - default ''
                        'LETTER',    // format - A4, for example, default ''
                        0,     // font size - default 0
                        '',    // default font family
                        15,    // margin_left
                        15,    // margin right
                        16,    // margin top
                        16,    // margin bottom
                        9,     // margin header
                        9,     // margin footer
                        'L'    // L - landscape, P - portrait
                        );

        $mpdf->SetHTMLFooter('<hr align="center"; width="100% "; noshade; color=#9F9F9F>
                                <table width="100%" style="vertical-align: bottom; font-family: tahoma,geneva,sans-serif; font-size: 8pt; color: #9F9F9F; ">
                                        <tr> 
                                            <!--<td width="50%" style="text-align: left;"></td> -->
                                            <td width="50%" align="center";>{PAGENO}/{nbpg}</td> 
                                        </tr>
                                </table>');    
       
       $mpdf->WriteHTML($extmod_str);        

       $mpdf->Output("DEPOSITO_PLAZO_" . $iCodDpz . ".pdf", "I");       
    } 	

    /*FORWARD*/
    public function fnc_imp_sol_fwd()
    {
        /*[AUT-20190828 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);   

        /*[AUT-20190828 : Parametros de Entrada desde ExtJS]*/
        $iCodFwd = $data[0];
 
        $forward = $this->mdl_exp_exc->mdl_csu_sol_fwd($iCodFwd,
                                                        '',
                                                        '',
                                                        0,
                                                        0,
                                                        0,
                                                        '0',
                                                        0,
                                                        0); 
        
        /*Insertamos el logo de la empresa*/        
        $img_log_goo = dirname(__FILE__).'/../../contents/logo.jpeg';       
            
        /*Abrimos la plantilla*/
        $extmod_str=implode("",file(dirname(__FILE__).'/../../contents/htm-imp-sol-fwd.htm'));
            
        foreach ($forward as $fwd)
        {            
            $extmod_str=str_replace('@@fec-sys', $fwd->tmp_fec_sys, $extmod_str);
            $extmod_str=str_replace('@@num-fwd', $fwd->tsf_cod_fwd, $extmod_str);

            $extmod_str=str_replace('@@rzn-scl', $fwd->tsp_rzn_scl, $extmod_str);
            $extmod_str=str_replace('@@emo-por', $fwd->tmp_emi_por, $extmod_str);
            $extmod_str=str_replace('@@atz-por', $fwd->tmp_aut_por, $extmod_str);
            $extmod_str=str_replace('@@des-tis', $fwd->tti_des_tis, $extmod_str);
            $extmod_str=str_replace('@@des-fwd', $fwd->tef_des_fwd, $extmod_str);  
            $extmod_str=str_replace('@@fec-emi', $fwd->tsf_fec_emi, $extmod_str);  

            //VENTAS --------------------------------------------------------------------------------------------
            $extmod_str=str_replace('@@ope-vta', $fwd->tsf_ope_vta, $extmod_str); 

            $extmod_str=str_replace('@@fec-ovt', $fwd->tsf_fec_ovt, $extmod_str);  
            $extmod_str=str_replace('@@fec-fvt', $fwd->tsf_fec_fvt, $extmod_str);  
            $extmod_str=str_replace('@@dia-vta', $fwd->tsf_dia_vta, $extmod_str);  

            $extmod_str=str_replace('@@usd-vta', number_format((float)$fwd->tsf_usd_vta, 2,',','.'), $extmod_str);
            $extmod_str=str_replace('@@tcc-vtu', number_format((float)$fwd->tsf_tcc_vtu, 2,',','.'), $extmod_str);
            $extmod_str=str_replace('@@pts-vta', number_format((float)$fwd->tsf_pts_vta, 2,',','.'), $extmod_str);
            $extmod_str=str_replace('@@tcc-vtd', number_format((float)$fwd->tsf_tcc_vtd, 2,',','.'), $extmod_str);
            $extmod_str=str_replace('@@mto-vta', number_format((float)$fwd->tsf_mto_vta, 2,',','.'), $extmod_str);
            //---------------------------------------------------------------------------------------------------

            //COMPRA --------------------------------------------------------------------------------------------
            $extmod_str=str_replace('@@ope-cmp', $fwd->tsf_ope_cmp, $extmod_str); 

            $extmod_str=str_replace('@@fec-ocm', $fwd->tsf_fec_ocm, $extmod_str);  
            $extmod_str=str_replace('@@fec-fcm', $fwd->tsf_fec_fcm, $extmod_str);  
            $extmod_str=str_replace('@@dia-cmp', $fwd->tsf_dia_cmp, $extmod_str);  

            $extmod_str=str_replace('@@usd-cmp', number_format((float)$fwd->tsf_usd_cmp, 2,',','.'), $extmod_str);
            $extmod_str=str_replace('@@tcc-cmu', number_format((float)$fwd->tsf_tcc_cmu, 2,',','.'), $extmod_str);
            $extmod_str=str_replace('@@pts-cmp', number_format((float)$fwd->tsf_pts_cmp, 2,',','.'), $extmod_str);
            $extmod_str=str_replace('@@tcc-cmd', number_format((float)$fwd->tsf_tcc_cmd, 2,',','.'), $extmod_str);
            $extmod_str=str_replace('@@mto-cmp', number_format((float)$fwd->tsf_mto_cmp, 2,',','.'), $extmod_str);
            //---------------------------------------------------------------------------------------------------
        
            $extmod_str=str_replace('@@uti-fwd', number_format((float)$fwd->tsf_uti_fwd, 2,',','.'), $extmod_str);
            $extmod_str=str_replace('@@fec-abn', $fwd->tsf_fec_abn, $extmod_str);  

            //---------------------------------------------------------------------------------------------------
            $extmod_str=str_replace('@@obs-fwd', $fwd->tdp_obs_fwd, $extmod_str);

            //---------------------------------------------------------------------------------------------------
            $extmod_str=str_replace('@@bco-inv', $fwd->tmp_bco_inv, $extmod_str);
            $extmod_str=str_replace('@@bco-rsc', $fwd->tmp_bco_rsc, $extmod_str);

        }

         $firma = $this
        ->mdl_exp_exc
        ->mdl_csu_apb_fwd(0,$iCodFwd,0);
        
        $cnt_fir = 0;
        foreach ($firma as $fir)   
        {              
            if  ($fir->taf_est_apb === '1'){

                $extmod_str_apb= '
                <td valign="center" colspan="1" style="background-color: rgb(219, 229, 241); text-align:left; height: 20px; text-align: center;">
                    <span style="font-size:11px;"><span style="font-family: tahoma,geneva,sans-serif;"><b>&nbsp;' . $fir->tmu_nom_usr . '</b></span></span>
                </td>';

                if  ($fir->tmu_rta_fir <> ''){
                    $extmod_str_fir= '
                        <td valign="center" colspan="1" style="padding: 0 0 5px 0; background-color: rgb(255, 255, 255); height: 100px;  text-align: center;" valign="bottom">
                            <span style="font-size:10px;"><span style="font-family: tahoma,geneva,sans-serif;"><IMG SRC="' . APPPATH . '../../archivos/arc_doc_mae_usr/' . $fir->tmu_rta_fir . '" WIDTH=200 HEIGHT=200 BORDER=0 ></span></span>
                        </td>';
                }else{
                    $extmod_str_fir= '
                        <td valign="center" colspan="1" style="padding: 0 0 5px 0; background-color: rgb(255, 255, 255); height: 100px;  text-align: center;" valign="bottom">
                            <span style="font-size:10px;"><span style="font-family: tahoma,geneva,sans-serif;"><IMG SRC="' . APPPATH . '../../images/firma.jpg" WIDTH=200 HEIGHT=200 BORDER=0 ></span></span>
                        </td>';
                }

                $adj_apb = $adj_apb . $extmod_str_apb;
                $adj_fir = $adj_fir . $extmod_str_fir;

                $cnt_fir+= 1;           
            }            
        }         
        
        if($cnt_fir > 0 && $fwd->tef_cod_fwd === '101'){
            
            $extmod_str=str_replace('@@aprobadores', '<tr>'.$adj_apb.'</tr><tr>'.$adj_fir.'</tr>', $extmod_str);
        }
        else{
            
            $adj_apb= '
                <td valign="center" colspan="1" style="background-color: rgb(219, 229, 241); text-align:left; height: 20px; text-align: center;">
                    <span style="font-size:11px;"><span style="font-family: tahoma,geneva,sans-serif;"><b>&nbsp;Sin aprobadores</b></span></span>
                </td>';
                
            $adj_fir= '
                <td valign="center" colspan="1" style="padding: 0 0 5px 0; background-color: rgb(255, 255, 255); height: 100px;  text-align: center;" valign="bottom">
                    <span style="font-size:10px;"><span style="font-family: tahoma,geneva,sans-serif;">&nbsp;No Firmar</span></span>
                </td>';
            
            $extmod_str=str_replace('@@aprobadores', '<tr>'.$adj_apb.'</tr><tr>'.$adj_fir.'</tr>', $extmod_str);
        }
        
        /*IMAGENES*/        
        $extmod_str=str_replace('@@img-log-goo', $img_log_goo, $extmod_str);  

        //configuramos PDF
        $mpdf= new mPDF(
                        '',    // mode - default ''
                        'LETTER',    // format - A4, for example, default ''
                        0,     // font size - default 0
                        '',    // default font family
                        15,    // margin_left
                        15,    // margin right
                        16,    // margin top
                        16,    // margin bottom
                        9,     // margin header
                        9,     // margin footer
                        'L'    // L - landscape, P - portrait
                        );

        $mpdf->SetHTMLFooter('<hr align="center"; width="100% "; noshade; color=#9F9F9F>
                                <table width="100%" style="vertical-align: bottom; font-family: tahoma,geneva,sans-serif; font-size: 8pt; color: #9F9F9F; ">
                                        <tr> 
                                            <!--<td width="50%" style="text-align: left;"></td> -->
                                            <td width="50%" align="center";>{PAGENO}/{nbpg}</td> 
                                        </tr>
                                </table>');    
       
       $mpdf->WriteHTML($extmod_str);        

       $mpdf->Output("FORWARD_" . $iCodFwd . ".pdf", "I");       
    }   

    /*FONDO MUTUO*/
    public function fnc_imp_sol_fmo()
    {
        /*[AUT-20190930 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);   

        /*[AUT-20190930 : Parametros de Entrada desde ExtJS]*/
        $iCodFmo = $data[0];
 
        $fondo = $this->mdl_exp_exc->mdl_csu_sol_fmo($iCodFmo,
                                                        '',
                                                        '',
                                                        0,
                                                        0,
                                                        '0',
                                                        0);         
        
        /*Insertamos el logo de la empresa*/        
        $img_log_goo = dirname(__FILE__).'/../../contents/logo.jpeg';       
            
        /*Abrimos la plantilla*/
        $extmod_str=implode("",file(dirname(__FILE__).'/../../contents/htm-imp-sol-fmo.htm'));
        $extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/htm-imp-det-sol-fmo.htm'));        
    
        foreach ($fondo as $fmo)
        {            
            $extmod_str=str_replace('@@fec-sys', $fmo->tmp_fec_sys, $extmod_str);
            $extmod_str=str_replace('@@num-fmo', $fmo->tsf_cod_fmo, $extmod_str);

            $extmod_str=str_replace('@@rzn-scl', $fmo->tsp_rzn_scl, $extmod_str);
            $extmod_str=str_replace('@@emo-por', $fmo->tmp_emi_por, $extmod_str);            
            $extmod_str=str_replace('@@atz-por', $fmo->tmp_aut_por, $extmod_str);

            $extmod_str=str_replace('@@des-fmo', $fmo->ttf_des_tfm, $extmod_str);            
            $extmod_str=str_replace('@@nom-fmo', $fmo->tsf_nom_fmo, $extmod_str);

            $extmod_str=str_replace('@@fec-inv', fcf_cmb_fec($fmo->tsf_fec_inv_inv), $extmod_str);
            $extmod_str=str_replace('@@mnt-inv', number_format((float)$fmo->tsf_mnt_inv_inv, 0,',','.'), $extmod_str);
            $extmod_str=str_replace('@@fec-rsc', fcf_cmb_fec($fmo->tsf_fec_rsc_inv), $extmod_str);
            $extmod_str=str_replace('@@mnt-rsc', number_format((float)$fmo->tsf_mnt_rsc_inv, 0,',','.'), $extmod_str);

            $extmod_str=str_replace('@@mon-org', $fmo->ttg_des_gnr, $extmod_str);            
            $extmod_str=str_replace('@@val-cmb', number_format((float)$fmo->tsf_val_cmb_inv, 2,',','.'), $extmod_str);

            $extmod_str=str_replace('@@plz-dia', $fmo->tsf_plz_dia_inv, $extmod_str); //
            $extmod_str=str_replace('@@tas-ped', number_format((float)$fmo->tsf_tas_ped, 6,',','.'), $extmod_str);
                                    
            $extmod_str=str_replace('@@bco-inv', $fmo->tmp_bco_inv, $extmod_str);
            //$extmod_str=str_replace('@@bco-rsc', $fmo->tmp_bco_rsc, $extmod_str); 

            $extmod_str=str_replace('@@mnt-gnc', number_format((float)$fmo->tsf_mnt_gnc_inv, 0,',','.'), $extmod_str);           
            $extmod_str=str_replace('@@obs-dpz', $fmo->tsf_obs_fmo, $extmod_str);

            $detalle =  $this
                    ->mdl_exp_exc
                    ->mdl_csu_det_fmo(0,
                                      $iCodFmo,
                                      '');

            foreach ($detalle as $det)
            {
                $extmod_str_det=str_replace('@@tdi_fec_inv', $det->mtx_fec_pgo, $extmod_str_det);
                $extmod_str_det=str_replace('@@tdi_cme_ddp', $det->tdf_cme_fmo, $extmod_str_det);                
                $extmod_str_det=str_replace('@@tdi_mto_pes', number_format((float)$det->tdf_mto_pes, 0,',','.'), $extmod_str_det);            
                $extmod_str_det=str_replace('@@tdi_tpo_mov', $det->tdf_tpo_mov, $extmod_str_det);
                $extmod_str_det=str_replace('@@tdi_rge_flu', $det->trf_des_rfl, $extmod_str_det);
                $extmod_str_det=str_replace('@@tdi_mir_est', $det->tae_des_aeg, $extmod_str_det);

                $adj_det_inv.= $extmod_str_det;
                $extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/htm-imp-det-sol-fmo.htm'));        
            }      

        }

        $extmod_str=str_replace('@@det_flu_inv', $adj_det_inv, $extmod_str); 

        $firma = $this
        ->mdl_exp_exc
        ->mdl_csu_apb_fmo(0,$iCodFmo,0);
        
        $cnt_fir = 0;
        foreach ($firma as $fir)   
        {             
            if  ($fir->taf_est_apb === '1'){

                $extmod_str_apb= '
                    <td valign="center" colspan="1" style="background-color: rgb(219, 229, 241); text-align:left; height: 20px; text-align: center;">
                        <span style="font-size:11px;"><span style="font-family: tahoma,geneva,sans-serif;"><b>&nbsp;' . $fir->tmu_nom_usr . '</b></span></span>
                    </td>';

                if  ($fir->tmu_rta_fir <> ''){
                    $extmod_str_fir= '
                        <td valign="center" colspan="1" style="padding: 0 0 5px 0; background-color: rgb(255, 255, 255); height: 100px;  text-align: center;" valign="bottom">
                            <span style="font-size:10px;"><span style="font-family: tahoma,geneva,sans-serif;"><IMG SRC="' . APPPATH . '../../archivos/arc_doc_mae_usr/' . $fir->tmu_rta_fir . '" WIDTH=200 HEIGHT=200 BORDER=0 ></span></span>
                        </td>';
                }else{
                    $extmod_str_fir= '
                        <td valign="center" colspan="1" style="padding: 0 0 5px 0; background-color: rgb(255, 255, 255); height: 100px;  text-align: center;" valign="bottom">
                            <span style="font-size:10px;"><span style="font-family: tahoma,geneva,sans-serif;"><IMG SRC="' . APPPATH . '../../images/firma.jpg" WIDTH=200 HEIGHT=200 BORDER=0 ></span></span>
                        </td>';
                }

                $adj_apb = $adj_apb . $extmod_str_apb;
                $adj_fir = $adj_fir . $extmod_str_fir;

                $cnt_fir+= 1;           
            }          
        }                
       
        if($cnt_fir > 0 && ($fmo->tef_cod_fmo === '101' || $fmo->tef_cod_fmo === '106' || $fmo->tef_cod_fmo === '107')){
            
            $extmod_str=str_replace('@@aprobadores', '<tr>'.$adj_apb.'</tr><tr>'.$adj_fir.'</tr>', $extmod_str);
        }
        else{
            
            $adj_apb= '
                <td valign="center" colspan="1" style="background-color: rgb(219, 229, 241); text-align:left; height: 20px; text-align: center;">
                    <span style="font-size:11px;"><span style="font-family: tahoma,geneva,sans-serif;"><b>&nbsp;Sin aprobadores</b></span></span>
                </td>';
                
            $adj_fir= '
                <td valign="center" colspan="1" style="padding: 0 0 5px 0; background-color: rgb(255, 255, 255); height: 100px;  text-align: center;" valign="bottom">
                    <span style="font-size:10px;"><span style="font-family: tahoma,geneva,sans-serif;">&nbsp;No Firmar</span></span>
                </td>';
            
            $extmod_str=str_replace('@@aprobadores', '<tr>'.$adj_apb.'</tr><tr>'.$adj_fir.'</tr>', $extmod_str);
        }

        /*IMAGENES*/                
        $extmod_str=str_replace('@@img-log-goo', $img_log_goo, $extmod_str);          

        //configuramos PDF
        $mpdf= new mPDF(
                        '',    // mode - default ''
                        'LETTER',    // format - A4, for example, default ''
                        0,     // font size - default 0
                        '',    // default font family
                        15,    // margin_left
                        15,    // margin right
                        16,    // margin top
                        16,    // margin bottom
                        9,     // margin header
                        9,     // margin footer
                        'L'    // L - landscape, P - portrait
                        );

        $mpdf->SetHTMLFooter('<hr align="center"; width="100% "; noshade; color=#9F9F9F>
                                <table width="100%" style="vertical-align: bottom; font-family: tahoma,geneva,sans-serif; font-size: 8pt; color: #9F9F9F; ">
                                        <tr> 
                                            <!--<td width="50%" style="text-align: left;"></td> -->
                                            <td width="50%" align="center";>{PAGENO}/{nbpg}</td> 
                                        </tr>
                                </table>');    
       
       $mpdf->WriteHTML($extmod_str);        

       $mpdf->Output("FONDO_MUTUO_" . $iCodFmo . ".pdf", "I");       
    }

    /*PROYECTO INGRESO*/
    public function fnc_imp_pry_ing()
    {
        /*[AUT-20161018 : Parametros de Entrada desde ExtJS]*/        
        $data = json_decode($this->input->get('jObject'), true);                

        $iCodPry = $data[0];
        $iCodEst = $data[1];
        $iDesPry = $data[2];
        $iCodSdp = $data[3];
        $iCodTcp = $data[4];
        $iFecIni = $data[5];
        $iFecFin = $data[6];    
        
        /*Abrimos la plantilla*/
        $extmod_str=implode("",file(dirname(__FILE__).'/../../contents/htm-imp-mnt-pry.htm'));  
        $extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/htm-det-mnt-pry.htm'));

        $this->load->model('mdl_pry_ing');

        $csu_mnt_pry = $this
                      ->mdl_pry_ing
                      ->mdl_csu_pry_ing($iCodPry,
                                        $iCodEst,
                                        $iDesPry,
                                        $iCodSdp,
                                        $iCodTcp,
                                        $iFecIni,
                                        $iFecFin);        
        
        foreach ($csu_mnt_pry as $pry)
        {         
            $extmod_str=str_replace('@@tmp_cod_pry', $pry->tmp_cod_pry, $extmod_str);
            $extmod_str=str_replace('@@tmu_nom_usr', $pry->tmu_nom_usr, $extmod_str);
            $extmod_str=str_replace('@@tmp_fec_emi', $pry->tmp_fec_emi, $extmod_str);
            $extmod_str=str_replace('@@tmp_des_pry', $pry->tmp_des_pry, $extmod_str);
            $extmod_str=str_replace('@@tsp_rzn_scl', $pry->tsp_rzn_scl, $extmod_str);
            $extmod_str=str_replace('@@ttp_des_tpr', $pry->ttp_des_tpr, $extmod_str);
            $extmod_str=str_replace('@@tmp_fec_pry', $pry->tmp_fec_pry, $extmod_str);
        }

        $adj_det_mpy = '';

        $csu_det_mpy = $this
                        ->mdl_exp_exc
                        ->mdl_csu_det_mpy(0,$iCodPry,1);

        foreach ($csu_det_mpy as $mpy)   
        {
            $extmod_str_det=str_replace('@@tmp_mon_org', $mpy->tmp_mon_org, $extmod_str_det);
            $extmod_str_det=str_replace('@@tdm_val_cmb', $mpy->tdm_val_cmb, $extmod_str_det);
            $extmod_str_det=str_replace('@@tdm_fec_cmb', $mpy->tdm_fec_cmb, $extmod_str_det);
            $extmod_str_det=str_replace('@@tdm_inv_org', $mpy->tdm_inv_org, $extmod_str_det);
            $extmod_str_det=str_replace('@@tdm_inv_pes', $mpy->tdm_inv_pes, $extmod_str_det);
            $extmod_str_det=str_replace('@@tep_des_est', $mpy->tep_des_est, $extmod_str_det);
            
            $adj_det_mpy = $adj_det_mpy . $extmod_str_det;
            $extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/htm-det-mnt-pry.htm'));
        }
                        
        $extmod_str=str_replace('@@imp_det_mpy', $adj_det_mpy, $extmod_str);
    
        //configuramos PDF
        $mpdf= new mPDF(
                        '',    // mode - default ''
                        '',    // format - A4, for example, default ''
                        0,     // font size - default 0
                        '',    // default font family
                        15,    // margin_left
                        15,    // margin right
                        16,    // margin top
                        16,    // margin bottom
                        9,     // margin header
                        9,     // margin footer
                        'L'    // L - landscape, P - portrait
                    );


        $mpdf->SetHTMLFooter('<hr align="center"; width="100% "; noshade; color=#9F9F9F><table width="100%" style="vertical-align: bottom; font-family: tahoma,geneva,sans-serif; font-size: 8pt; color: #9F9F9F; "><tr> <td width="50%" style="text-align: left;">' . $pie_cmp_vta . '</td> <td width="50%" align="right";>{PAGENO}/{nbpg}</td> </tr></table>');

        $mpdf->WriteHTML($extmod_str);
        $mpdf->Output("Impresion_Proyecto_Ingreso.pdf", "I");
    }  
}