<?php 
include 'enableCORS.php';
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Cls_mnt_pry extends CI_Controller {

	Public function __construct(){
		enableCORS(); 
		parent::__construct();
		/* CARGAMOS LIBRERIAS PARA ESTE CONTROLLER*/                
		include(dirname(__FILE__)."/../libraries/PHPExcel/Classes/PHPExcel.php");
		include(dirname(__FILE__)."/../libraries/MPDF54/mpdf.php");          
		$this->load->model(array('mdl_exp_exc'));	
	}
	
	Public Function fnc_grb_mnt_pry()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  
				
		/*Se obtinene la fecha y hora para generar código interno*/
		$iKeyIdd = substr(Date('Ymdhis').microtime(),0,15);
		
		/*[AUT-20210112 : Parametros de Entrada desde ExtJS]*/
		$iCodPry = $data[0];
		$iFecEmi = $data[1];
		$iCodEst = $data[2];
		$iDesPry = $data[3];
		$iCodUsr = $data[4];
		$iCodSdp = $data[5];
		$iCodBco = $data[6];
		$iTipCta = $data[7];
		$iCodRfl = $data[8];
		$iCodTcp = $data[9];
		$iFecPry = $data[10];
		$iInvPes = $data[11];
		$iSldPes = $data[12];

		/*[AUT-20210112 : Reemplazo de apóstrofe para parámetros de Entrada desde ExtJS]*/
		$iCodPry = str_replace("'", "´", $iCodPry);
		$iKeyIdd = str_replace("'", "´", $iKeyIdd);
		$iFecEmi = str_replace("'", "´", $iFecEmi);
		$iCodEst = str_replace("'", "´", $iCodEst);
		$iDesPry = str_replace("'", "´", $iDesPry);
		$iCodUsr = str_replace("'", "´", $iCodUsr);
		$iCodSdp = str_replace("'", "´", $iCodSdp);
		$iCodBco = str_replace("'", "´", $iCodBco);
		$iTipCta = str_replace("'", "´", $iTipCta);
		$iCodRfl = str_replace("'", "´", $iCodRfl);
		$iCodTcp = str_replace("'", "´", $iCodTcp);
		$iFecPry = str_replace("'", "´", $iFecPry);
		$iInvPes = str_replace("'", "´", $iInvPes);
		$iSldPes = str_replace("'", "´", $iSldPes);
		$iInvPes = str_replace(",", ".", $iInvPes);
		$iSldPes = str_replace(",", ".", $iSldPes);

		/*[AUT-20210112 : Formación de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim(strtoupper($iCodPry));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iKeyIdd)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iFecEmi)) . "'";
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodEst));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iDesPry)) . "'";
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodUsr));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodSdp));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodBco));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iTipCta));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodRfl));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodTcp));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iFecPry)) . "'";
		$iPrm = $iPrm . "   , " . trim(strtoupper($iInvPes));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iSldPes));

		/*[AUT-20210112 : Llamada al Servicio MySQL]*/	
		$sSql = "sva_grb_mnt_pry";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}
		
        echo json_encode(
                    array(
                      'success'  => true,
                      'data'     => $data,'e' => $sExe                   
                    )
        );  
	}
	
	Public Function fnc_csu_mnt_pry()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  
		
		/*[AUT-20210112 : Parametros de Entrada desde ExtJS]*/
		$iCodPry = $data[0];
		$iCodEst = $data[1];
		$iDesPry = $data[2];
		$iCodSdp = $data[3];
		$iCodTcp = $data[4];
		$iFecIni = $data[5];
		$iFecFin = $data[6];

		/*[AUT-20210112 : Reemplazo de apóstrofe para parámetros de Entrada desde ExtJS]*/
		$iCodPry = str_replace("'", "´", $iCodPry);
		$iCodEst = str_replace("'", "´", $iCodEst);
		$iDesPry = str_replace("'", "´", $iDesPry);
		$iCodSdp = str_replace("'", "´", $iCodSdp);
		$iCodTcp = str_replace("'", "´", $iCodTcp);
		$iFecIni = str_replace("'", "´", $iFecIni);
		$iFecFin = str_replace("'", "´", $iFecFin);

		/*[AUT-20210112 : Formación de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "      " . trim(strtoupper($iCodPry));
		$iPrm = $iPrm . "   ,  " . trim(strtoupper($iCodEst));
		$iPrm = $iPrm . "   ,'%" . trim(strtoupper($iDesPry)) . "%'";
		$iPrm = $iPrm . "   , '" . trim(strtoupper($iCodSdp)) . "'";
		$iPrm = $iPrm . "   ,  " . trim(strtoupper($iCodTcp));
		$iPrm = $iPrm . "   , '" . trim(strtoupper($iFecIni)) . "'";
		$iPrm = $iPrm . "   , '" . trim(strtoupper($iFecFin)) . "'";

		/*[AUT-20210112 : Llamada al Servicio MySQL]*/	
		$sSql = "svc_csu_mnt_pry";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}
		
        echo json_encode(
                    array(
                      'success'  => true,
                      'data'     => $data          
                    )
        );  
	}
	
	
	
	Public Function fnc_exp_exc_pry()
    {          
		/*[AUT-20161018 : Parametros de Entrada desde ExtJS]*/        
		$data = json_decode($this->input->get('jObject'), true);                

		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/
		$iCodPry = $data[0];
		$iCodEst = $data[1];
		$iDesPry = $data[2];
		$iCodSdp = $data[3];	
		$iFecIni = $data[4];
		$iFecFin = $data[5];
		$iCodTcp = $data[6];	

		if($iCodTcp==null){$iCodTcp=0;}

		if($iFecIni <> ""){

		$iFecIni = $iFecIni.' 00:00:00';
		$iFecFin = $iFecFin.' 23:59:59';
		}
		

		/** CABECERAS **/
		error_reporting(E_ALL);
		ini_set('display_errors', TRUE);
		ini_set('display_startup_errors', TRUE);        

		ini_set("memory_limit", "-1");
		set_time_limit(0);	
		
		//NUEVO OBJETO GENERAL
		$objPHPExcel = new PHPExcel();

		//PROPIEDADES METADATOS
		$objPHPExcel->getProperties()->setCreator("Contacar")
                                     ->setLastModifiedBy("Operador de Contacar")
									 ->setTitle("Office Exportacion")
									 ->setSubject("Office Exportacion")
									 ->setDescription("Office Exportacion")
									 ->setKeywords("office 2007 openxml php")
									 ->setCategory("Office Exportacion");                                     

		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Proyectos');        
		$objPHPExcel->getActiveSheet()
					->getStyle('B2')
					->getFont()
					->setName('Calibri')
					->setSize(15)
					->setBold(true)
					->getColor();        


		$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('B5', 'N Proyecto')
					->setCellValue('C5', 'Estado')
					->setCellValue('D5', 'F Proyecto')
					->setCellValue('E5', 'Proyecto')    
					->setCellValue('F5', 'Inversion Pesos')  
					->setCellValue('G5', 'Saldo Pesos')                                
					->setCellValue('H5', 'Tipo de Proyecto')
					->setCellValue('I5', 'Empresa');

		//Configuración de tipos de letra                         
		$objPHPExcel->getActiveSheet()
					->getStyle('B5:I5')
					->getFont()
					->setName('Calibri')
					->setSize(8)
					->setBold(true)        
					->getColor()
					->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        

		//fondo a celda
		$objPHPExcel->getActiveSheet()
					->getStyle('B5:I5')
					->getFill()
					->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
					->getStartColor()
					->setARGB('&H808080');         

		$csu_mnt_pry = $this
			->mdl_exp_exc
			->mdl_csu_mnt_pry($iCodPry,$iCodEst,$iDesPry,$iCodSdp,$iCodTcp,$iFecIni,$iFecFin);
		
		$Ct = 5;

		/*tamaño letra en grilla*/
		$objPHPExcel->getDefaultStyle()
		->getFont()                    
		->setName('Calibri')
		->setSize(8)
		->setBold(false)        
		->getColor();   

		foreach ($csu_mnt_pry as $pry)
		{
			$Ct = $Ct + 1;

			$objPHPExcel->setActiveSheetIndex(0)
			->setCellValue('B' . $Ct, $pry->tmp_cod_pry)
			->setCellValue('C' . $Ct, $pry->tep_des_est)
			->setCellValue('D' . $Ct, $pry->tmp_fec_pry)
			->setCellValue('E' . $Ct, $pry->tmp_des_pry)
			->setCellValue('F' . $Ct, $pry->tmp_inv_pes)
			->setCellValue('G' . $Ct, $pry->tmp_sld_pes)
			->setCellValue('H' . $Ct, $pry->ttp_des_tpr)
			->setCellValue('I' . $Ct, $pry->tsp_rzn_scl);
			
			$objPHPExcel->getActiveSheet()->getStyle('B' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER); 
			$objPHPExcel->getActiveSheet()->getStyle('D' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER); 
			$objPHPExcel->getActiveSheet()->getStyle('F' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT); 
			$objPHPExcel->getActiveSheet()->getStyle('G' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT); 

			$objPHPExcel->getActiveSheet()->getStyle('F' . $Ct . ':G' . $Ct )->getNumberFormat()->setFormatCode('$#,##0;[Red]-$#,##0');

		}   



		$objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
		//Unir celdas 
		$objPHPExcel->getActiveSheet()->mergeCells('B2:D2');

		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true); 
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);         
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);  
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
		

		$objPHPExcel->getActiveSheet()->setTitle('Exportacion');
		$objPHPExcel->setActiveSheetIndex(0);         

		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="Listado de Proyectos.xls"');
		header('Cache-Control: max-age=0');
		header('Cache-Control: max-age=1');       

		header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
		header ('Cache-Control: cache, must-revalidate');
		header ('Pragma: public'); // HTTP/1.0

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');      
    }  
	
	
	
	Public Function fnc_upd_est_apb_pry()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  
		
		/*[AUT-20201213 : Parametros de Entrada desde ExtJS]*/
		$iCodPry = $data[0];
		$iCodMpy = $data[1];
		$iCodUsr = $data[2];
		$iEstApb = $data[3];

		/*[AUT-20201213 : Reemplazo de apóstrofe para parámetros de Entrada desde ExtJS]*/
		$iCodPry = str_replace("'", "´", $iCodPry);
		$iCodMpy = str_replace("'", "´", $iCodMpy);
		$iCodUsr = str_replace("'", "´", $iCodUsr);
		$iEstApb = str_replace("'", "´", $iEstApb);

		/*[AUT-20201213 : Formación de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim($iCodPry);
		$iPrm = $iPrm . "   , " . trim($iCodMpy);
		$iPrm = $iPrm . "   , " . trim($iCodUsr);
		$iPrm = $iPrm . "   , " . trim($iEstApb);

		/*[AUT-20201213 : Llamada al Servicio MySQL]*/	
		$sSql = "sva_upd_est_apb_pry";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}
		
		echo json_encode(
			    array(
			      'success'  => true,
			      'data'     => $data                     
			    )
		);  
	}
	
	
	
	Public Function fnc_grb_apb_pry()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  
		
		/*[AUT-20170607 : Parametros de Entrada desde ExtJS]*/
		$iCodPry = $data[0];
		$iCodMpy = $data[1];
		$iCodSpd = $data[2];
		$iUsrUno = $data[3];
		$iUsrDos = $data[4];

		/*[AUT-20170607 : Reemplazo de apóstrofe para parámetros de Entrada desde ExtJS]*/
		$iCodPry = str_replace("'", "´", $iCodPry);
		$iCodMpy = str_replace("'", "´", $iCodMpy);
		$iCodSpd = str_replace("'", "´", $iCodSpd);
		$iUsrUno = str_replace("'", "´", $iUsrUno);
		$iUsrDos = str_replace("'", "´", $iUsrDos);	

		/*[AUT-20170607 : Formación de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim($iCodPry);
		$iPrm = $iPrm . "   , " . trim($iCodMpy);
		$iPrm = $iPrm . "   , " . trim($iCodSpd);
		$iPrm = $iPrm . "   , " . trim($iUsrUno);
		$iPrm = $iPrm . "   , " . trim($iUsrDos);	
		/*[AUT-20170607 : Llamada al Servicio MySQL]*/	
		$sSql = "sva_grb_apb_pry";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
		
		$query = $this->db->query($sExe);

		$data = array();
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}
		
		echo json_encode(
			    array(
			      'success'  => true,
			      'data'     => $data                     
			    )
		);  
	}
	
	
	Public Function fnc_csu_apb_pry()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  
		
		/*[AUT-20170607 : Parametros de Entrada desde ExtJS]*/
		$iCodApb = $data[0];
		$iCodMpy = $data[1];
		$iCodUsr = $data[2];

		/*[AUT-20170607 : Reemplazo de apóstrofe para parámetros de Entrada desde ExtJS]*/
		$iCodApb = str_replace("'", "´", $iCodApb);
		$iCodMpy = str_replace("'", "´", $iCodMpy);
		$iCodUsr = str_replace("'", "´", $iCodUsr);

		/*[AUT-20170607 : Formación de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim(strtoupper($iCodApb));
		$iPrm = $iPrm . "  ,  " . trim(strtoupper($iCodMpy));
		$iPrm = $iPrm . "  ,  " . trim(strtoupper($iCodUsr));

		/*[AUT-20170607 : Llamada al Servicio MySQL]*/	
		$sSql = "svc_csu_apb_pry";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}
		
		echo json_encode(
			    array(
			      'success'  => true,
			      'data'     => $data                     
			    )
		);  
	}
	
	
	
	/*ENVIA NOTIFICACION*/
	public function fnc_ntf_mnt_pry()
	{   
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);                       

		/*[AUT-20201213 : Parametros de Entrada desde ExtJS]*/ 
		$iCodPry = $data[0]; 
		$iCodEst = 0;
		$iDesPry = '';
		$iCodSdp = '0';
		$iCodTcp = 0;
		$iFecIni = '';
		$iFecFin = '';
		$iEstNtf = $data[1]; 
		$iCorOpe = $data[2]; 
		$iCodDet = $data[3];

		$this->load->helper('email');
		$config = $this->config->item('correo');
		$this->load->library('email', $config);               
      
        /*Abrimos la plantilla*/
        /**/
			
		$extmod_str = 'DARIO';
		$cEmlPor =     "dcaceres@ebqlabs.cl";		
		$cEmlAbpsCrl = "dcaceres@ebqlabs.cl";  
			
		if (valid_email('sendmail@ebqdeveloper.cl'))
		{    
			
			/*Abrimos la plantilla*/
			$extmod_str=implode("",file(dirname(__FILE__).'/../../contents/htm-ntf-mnt-pry.htm'));  
			$extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/htm-det-mnt-pry.htm'));

			$csu_mnt_pry = $this
				->mdl_exp_exc
				->mdl_csu_mnt_pry($iCodPry,$iCodEst,$iDesPry,$iCodSdp,$iCodTcp,$iFecIni,$iFecFin);
			
			$csu_det_mpy = $this
			->mdl_exp_exc
			->mdl_csu_det_mpy($iCodDet,0,1);
			
			foreach ($csu_mnt_pry as $pry)
			{         
				$extmod_str=str_replace('@@tmp_cod_pry', $pry->tmp_cod_pry, $extmod_str);
				$extmod_str=str_replace('@@tmu_nom_usr', $pry->tmu_nom_usr, $extmod_str);
				$extmod_str=str_replace('@@tmp_fec_emi', $pry->tmp_fec_emi, $extmod_str);
				$extmod_str=str_replace('@@tmp_des_pry', $pry->tmp_des_pry, $extmod_str);
				$extmod_str=str_replace('@@ttp_des_tpr', $pry->ttp_des_tpr, $extmod_str);
				$extmod_str=str_replace('@@tmp_fec_pry', $pry->tmp_fec_pry, $extmod_str);
				$extmod_str=str_replace('@@tmc_enc_cmp', $pry->tsp_rzn_scl, $extmod_str);
				$extmod_str=str_replace('@@Para', '', $extmod_str);
				$extmod_str=str_replace('@@tmp_fec_sys', $pry->tmp_fec_sys, $extmod_str);
				
				$iEmlUsr = $pry->tmu_eml_usr;
				
			}
			$adj_det_mpy = '';
			foreach ($csu_det_mpy as $mpy)   
			{
				$extmod_str_det=str_replace('@@tmp_mon_org', $mpy->tmp_mon_org, $extmod_str_det);
				$extmod_str_det=str_replace('@@tdm_val_cmb', $mpy->tdm_val_cmb, $extmod_str_det);
				$extmod_str_det=str_replace('@@tdm_fec_cmb', $mpy->tdm_fec_cmb, $extmod_str_det);
				$extmod_str_det=str_replace('@@tdm_inv_org', $mpy->tdm_inv_org, $extmod_str_det);
				$extmod_str_det=str_replace('@@tdm_inv_pes', $mpy->tdm_inv_pes, $extmod_str_det);
				$extmod_str_det=str_replace('@@tep_des_est', $mpy->tep_des_est, $extmod_str_det);
				
				
				$iEmlAtz = $mpy->tmp_eml_atz;
				$iNtfMntPry = $mpy->ntf_mnt_pry;
				
				$adj_det_mpy = $adj_det_mpy . $extmod_str_det;
				$extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/htm-det-mnt-pry.htm'));
			}
		
			$extmod_str=str_replace('@@imp_det_mpy', $adj_det_mpy, $extmod_str);
			
			if($iEstNtf === "APROBAR"){
				$txt_asu = " Aprobada N° ".$iCodPry;
				$txt_eml = "Se ha aprobado el siguiente proyecto";
			}
			elseif($iEstNtf === "RECHAZAR"){
				$txt_asu = " rechazada N° ".$iCodPry;
				$txt_eml = "Se ha rechazado el siguiente proyecto";
			}
			elseif($iEstNtf === "ANULAR"){
				$txt_asu = " anulada N° ".$iCodPry;
				$txt_eml = "Se ha anulado el siguiente proyecto";
			}
			elseif($iEstNtf === "SOLICITUD"){
				$txt_asu = " solicitud N° ".$iCodPry;
				$txt_eml = "Se ha solicitado la aprobación del siguiente proyecto";
			}
			elseif($iEstNtf === "NUEVA APROBACION"){
				$txt_asu = " solicitud N° ".$iCodPry;
				$txt_eml = "Se ha solicitado nueva aprobación del siguiente proyecto";
			}
		
			$extmod_str=str_replace('@@txt-eml', $txt_eml, $extmod_str);
			
			//Ponemos la dirección de correo que enviará el email y un nombre                        
			$this->email->from(DIRCORREO, EMPCORREO);
			$this->email->to($iCorOpe.','.$iEmlUsr.','.$iEmlAtz);       
			$this->email->cc($iNtfMntPry);
			//$this->email->to("dcaceres@ebqlabs.cl"); 
			
		
			//Definimos el asunto del mensaje                        			
			$this->email->subject($txt_asu);
			//Definimos el mensaje a enviar
			$this->email->message($extmod_str);           

			//Enviamos el email y si se produce bien o mal que avise con una flasdata
			if($this->email->send()){

				echo json_encode(
					array(
						"success"           => true						
					)
				);
			}else{

				echo json_encode(
					array(
						"success" => false,
						"error"   => $this->email->print_debugger()                        
					)
				);
			} 
		}
		else{
			echo json_encode(
				array(
					"success"=> false
				)
			);
		}  

	}

	/*ENVIA NOTIFICACION MASIVA*/
	public function fnc_ntf_mnt_pry_msv()
	{   
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);                       

		/*[AUT-20201213 : Parametros de Entrada desde ExtJS]*/ 
		$iCodPry = $data[0];					
		$iCodDet = $data[1];
		$iCorOpe = $data[2];
		$iEstNtf = $data[3];

	           
    

			$csu_mnt_pry = $this
				->mdl_exp_exc
				->mdl_csu_mnt_pry($iCodPry,0,'','0',0,'','');
			
			$csu_det_mpy = $this
			->mdl_exp_exc
			->mdl_csu_det_mpy($iCodDet,0,1);
			
			foreach ($csu_mnt_pry as $pry)
			{         
				$iEmlUsr = $pry->tmu_eml_usr;
				
			}
			$adj_det_mpy = '';
			foreach ($csu_det_mpy as $mpy)   
			{
				
				$iNtfMntPry = $mpy->ntf_mnt_pry;
			
			}
		
			echo json_encode(
				array(
					'success'          => true,
					'tmp_eml_por'       => $iEmlUsr,
					'tmp_eml_apbs_msv'  => $iNtfMntPry.','.$iCorOpe
				)
			);

	}

	/*ENVIA NOTIFICACION MASIVA*/
	public function fnc_ntf_mnt_pry_msvOld()
	{   
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);                       


	
		/*[AUT-20201213 : Parametros de Entrada desde ExtJS]*/ 
		$iCodPry = $data[0];					
		$iCodDet = $data[1];
		$iCorOpe = $data[2];
		$iEstNtf = $data[3];


		$this->load->helper('email');
		$config = $this->config->item('correo');
		$this->load->library('email', $config);               
      
    /*Abrimos la plantilla*/			
		$extmod_str = '';
			
		if (valid_email('sendmail@ebqdeveloper.cl'))
		{			
			/*Abrimos la plantilla*/
			$extmod_str=implode("",file(dirname(__FILE__).'/../../contents/htm-ntf-mnt-pry.htm'));  
			$extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/htm-det-mnt-pry.htm'));

			$csu_mnt_pry = $this
				->mdl_exp_exc
				->mdl_csu_mnt_pry($iCodPry,0,'','0',0,'','');
			
			$csu_det_mpy = $this
			->mdl_exp_exc
			->mdl_csu_det_mpy($iCodDet,0,1);
			
			foreach ($csu_mnt_pry as $pry)
			{         
				$extmod_str=str_replace('@@tmp_cod_pry', $pry->tmp_cod_pry, $extmod_str);
				$extmod_str=str_replace('@@tmu_nom_usr', $pry->tmu_nom_usr, $extmod_str);
				$extmod_str=str_replace('@@tmp_fec_emi', $pry->tmp_fec_emi, $extmod_str);
				$extmod_str=str_replace('@@tmp_des_pry', $pry->tmp_des_pry, $extmod_str);
				$extmod_str=str_replace('@@ttp_des_tpr', $pry->ttp_des_tpr, $extmod_str);
				$extmod_str=str_replace('@@tmp_fec_pry', $pry->tmp_fec_pry, $extmod_str);
				$extmod_str=str_replace('@@tmc_enc_cmp', $pry->tsp_rzn_scl, $extmod_str);
				$extmod_str=str_replace('@@Para', '', $extmod_str);
				$extmod_str=str_replace('@@tmp_fec_sys', $pry->tmp_fec_sys, $extmod_str);
				
				$iEmlUsr = $pry->tmu_eml_usr;
				
			}
			$adj_det_mpy = '';
			foreach ($csu_det_mpy as $mpy)   
			{
				$extmod_str_det=str_replace('@@tmp_mon_org', $mpy->tmp_mon_org, $extmod_str_det);
				$extmod_str_det=str_replace('@@tdm_val_cmb', $mpy->tdm_val_cmb, $extmod_str_det);
				$extmod_str_det=str_replace('@@tdm_fec_cmb', $mpy->tdm_fec_cmb, $extmod_str_det);
				$extmod_str_det=str_replace('@@tdm_inv_org', $mpy->tdm_inv_org, $extmod_str_det);
				$extmod_str_det=str_replace('@@tdm_inv_pes', $mpy->tdm_inv_pes, $extmod_str_det);
				$extmod_str_det=str_replace('@@tep_des_est', $mpy->tep_des_est, $extmod_str_det);
				
				
				$iEmlAtz = $mpy->tmp_eml_atz;
				$iNtfMntPry = $mpy->ntf_mnt_pry;
				
				$adj_det_mpy = $adj_det_mpy . $extmod_str_det;
				$extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/htm-det-mnt-pry.htm'));
			}
		
			$extmod_str=str_replace('@@imp_det_mpy', $adj_det_mpy, $extmod_str);
			
			if($iEstNtf === "APROBAR"){
				$txt_asu = " Aprobada N° ".$iCodPry;
				$txt_eml = "Se ha aprobado el siguiente proyecto";
			}
			
		
			$extmod_str=str_replace('@@txt-eml', $txt_eml, $extmod_str);
			
			//Ponemos la dirección de correo que enviará el email y un nombre                        
			$this->email->from(DIRCORREO, EMPCORREO);
			$this->email->to($iCorOpe.','.$iEmlUsr.','.$iEmlAtz);       
			$this->email->cc($iNtfMntPry);
					
			//Definimos el asunto del mensaje                        			
			$this->email->subject($txt_asu);
			//Definimos el mensaje a enviar
			$this->email->message($extmod_str);           

			//Enviamos el email y si se produce bien o mal que avise con una flasdata
			if($this->email->send()){

				echo json_encode(
					array(
						"success"           => true,
						'tmp_eml_por'       => $iEmlUsr,
						'tmp_eml_apbs_msv'  => $iNtfMntPry.','.$iCorOpe
					)
				);
			}else{

				echo json_encode(
					array(
						"success" => false,
						"error"   => $this->email->print_debugger()                        
					)
				);
			} 
		}
		else{
			echo json_encode(
				array(
					"success"=> false
				)
			);
		}  

	}
	
	
	public function fnc_imp_mnt_pry()
	{                  
		/*[AUT-20161018 : Parametros de Entrada desde ExtJS]*/        
		$data = json_decode($this->input->get('jObject'), true);                

		$iCodPry = $data[0];
		$iCodEst = $data[1];
		$iDesPry = $data[2];
		$iCodSdp = $data[3];
		$iCodTcp = $data[4];
		$iFecIni = $data[5];
		$iFecFin = $data[6];
	
		
		/*Abrimos la plantilla*/
		$extmod_str=implode("",file(dirname(__FILE__).'/../../contents/htm-imp-mnt-pry.htm'));  
		$extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/htm-det-mnt-pry.htm'));

		$csu_mnt_pry = $this
			->mdl_exp_exc
			->mdl_csu_mnt_pry($iCodPry,$iCodEst,$iDesPry,$iCodSdp,$iCodTcp,$iFecIni,$iFecFin);
		
		$csu_det_mpy = $this
		->mdl_exp_exc
		->mdl_csu_det_mpy(0,$iCodPry,1);
		
		foreach ($csu_mnt_pry as $pry)
		{         
			$extmod_str=str_replace('@@tmp_cod_pry', $pry->tmp_cod_pry, $extmod_str);
			$extmod_str=str_replace('@@tmu_nom_usr', $pry->tmu_nom_usr, $extmod_str);
			$extmod_str=str_replace('@@tmp_fec_emi', $pry->tmp_fec_emi, $extmod_str);
			$extmod_str=str_replace('@@tmp_des_pry', $pry->tmp_des_pry, $extmod_str);
			$extmod_str=str_replace('@@tsp_rzn_scl', $pry->tsp_rzn_scl, $extmod_str);
			$extmod_str=str_replace('@@ttp_des_tpr', $pry->ttp_des_tpr, $extmod_str);
			$extmod_str=str_replace('@@tmp_fec_pry', $pry->tmp_fec_pry, $extmod_str);
		}
		$adj_det_mpy = '';
		foreach ($csu_det_mpy as $mpy)   
		{
			$extmod_str_det=str_replace('@@tmp_mon_org', $mpy->tmp_mon_org, $extmod_str_det);
			$extmod_str_det=str_replace('@@tdm_val_cmb', $mpy->tdm_val_cmb, $extmod_str_det);
			$extmod_str_det=str_replace('@@tdm_fec_cmb', $mpy->tdm_fec_cmb, $extmod_str_det);
			$extmod_str_det=str_replace('@@tdm_inv_org', $mpy->tdm_inv_org, $extmod_str_det);
			$extmod_str_det=str_replace('@@tdm_inv_pes', $mpy->tdm_inv_pes, $extmod_str_det);
			$extmod_str_det=str_replace('@@tep_des_est', $mpy->tep_des_est, $extmod_str_det);
			
			$adj_det_mpy = $adj_det_mpy . $extmod_str_det;
			$extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/htm-det-mnt-pry.htm'));
		}
		
				
		$extmod_str=str_replace('@@imp_det_mpy', $adj_det_mpy, $extmod_str);
	
		//configuramos PDF
		$mpdf= new mPDF(
			'',    // mode - default ''
			'',    // format - A4, for example, default ''
			0,     // font size - default 0
			'',    // default font family
			15,    // margin_left
			15,    // margin right
			16,    // margin top
			16,    // margin bottom
			9,     // margin header
			9,     // margin footer
			'L'    // L - landscape, P - portrait
		);


		$mpdf->SetHTMLFooter('<hr align="center"; width="100% "; noshade; color=#9F9F9F><table width="100%" style="vertical-align: bottom; font-family: tahoma,geneva,sans-serif; font-size: 8pt; color: #9F9F9F; "><tr> <td width="50%" style="text-align: left;">'.$pie_cmp_vta.'</td> <td width="50%" align="right";>{PAGENO}/{nbpg}</td> </tr></table>');

		$mpdf->WriteHTML($extmod_str);
		$mpdf->Output("Impresion Proyecto.pdf", "I");
	}
}