<?php
include 'enableCORS.php';
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Cls_rpt_prp extends CI_Controller {

	Public function __construct(){
		enableCORS(); 
		parent::__construct();
		/* CARGAMOS LIBRERIAS PARA ESTE CONTROLLER*/       
		include(dirname(__FILE__)."/../libraries/PHPExcel/Classes/PHPExcel.php");      
		include(dirname(__FILE__)."/../libraries/MPDF54/mpdf.php");
		$this->load->model(array('mdl_exp_exc')); 
		$this->load->model(array('mdl_exp_pdf')); 

	}

	
	Public Function fnc_csu_pro_men()
	{  
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  
		
		ini_set("memory_limit", "-1");
		set_time_limit(0);

		/*[AUT-20180211 : Parametros de Entrada desde ExtJS]*/
		$iCodPro = $data[0];
		$iFecIni = $data[1];
		$iFecFin = $data[2];

		/*[AUT-20180211 : Reemplazo de ap�strofe para par�metros de Entrada desde ExtJS]*/
		$iCodPro = str_replace("'", "�", $iCodPro);
		$iFecIni = str_replace("'", "�", $iFecIni);
		$iFecFin = str_replace("'", "�", $iFecFin);

		/*[AUT-20180211 : Formaci�n de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim(strtoupper($iCodPro));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iFecIni)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iFecFin)) . "'";

		/*[AUT-20180211 : Llamada al Servicio MySQL]*/	
		$sSql = "svc_csu_pro_men";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}
		
		echo json_encode(
			    array(
			      'success'  => true,
			      'data'     => $data                     
			    )
		);  
	
	}

	Public Function fnc_exp_exc_prp()
	{
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/        
		$data = json_decode($this->input->get('jObject'), true);  						
		
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/
		$iCodPro = $data[0];
		$iFecIni = $data[1];
		$iFecFin = $data[2];
		
		/** CABECERAS **/
		error_reporting(E_ALL);
		ini_set('display_errors', TRUE);
		ini_set('display_startup_errors', TRUE);   

		ini_set("memory_limit", "-1");
		set_time_limit(0);		
		
		//NUEVO OBJETO GENERAL
		$objPHPExcel = new PHPExcel();
		

		//PROPIEDADES METADATOS
		$objPHPExcel->getProperties()->setCreator("Contacar")
					     ->setLastModifiedBy("Operador de Contacar")
					     ->setTitle("Office Exportacion")
					     ->setSubject("Office Exportacion")
					     ->setDescription("Office Exportacion")
					     ->setKeywords("office 2007 openxml php")
					     ->setCategory("Office Exportacion");                                      
		
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado Periodo por Due�os de Propiedades');        
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B2')
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(15)
			    ->setBold(true)
			    ->getColor();        
		       
		/*Centrar Celdas*/            
		$objPHPExcel->getActiveSheet()->getStyle('B5:U5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
		$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('B5', 'N Liquidacion')
				->setCellValue('C5', 'Propietario')
			    ->setCellValue('D5', 'Unidad de Negocio')
			    ->setCellValue('E5', 'Departamento')
			    ->setCellValue('F5', 'Torre')
			    ->setCellValue('G5', 'Monto de Arriendo')
			    ->setCellValue('H5', 'Abono Garantia')
			    ->setCellValue('I5', 'Gastos Comunes')
			    ->setCellValue('J5', 'Gastos Agua')
				->setCellValue('K5', 'Gastos Luz')
				->setCellValue('L5', 'Gastos Constribuciones')
				->setCellValue('M5', 'Gastos Limpieza')
				->setCellValue('N5', 'Multa')
				->setCellValue('O5', 'Gastos Arriendo')
				->setCellValue('P5', 'Dev. Gar.')
				->setCellValue('Q5', 'Pago Adm.')
				->setCellValue('R5', 'IVA Adm.')
				->setCellValue('S5', 'Pago Com.')
				->setCellValue('T5', 'Iva Com.')
				->setCellValue('U5', 'Total Final');
			    
		//Configuraci�n de tipos de letra                         
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B5:U5')
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(true)        
			    ->getColor()
			    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
			    
		//fondo a celda
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B5:U5')
			    ->getFill()
			    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
			    ->getStartColor()
			    ->setARGB('&H808080');         

		$csu_pro_men = $this
                        ->mdl_exp_exc
                        ->mdl_csu_pro_men($iCodPro,$iFecIni,$iFecFin);  

		$Ct = 5;		
		
		/*tama�o letra en grilla*/
		$objPHPExcel->getDefaultStyle()
			    ->getFont()                    
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(false)        
			    ->getColor();   
		   
		foreach ($csu_pro_men as $pro)
		{
			$Ct = $Ct + 1;
			
			$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('B' . $Ct, $pro->tle_num_liq)
					->setCellValue('C' . $Ct, $pro->tmp_nom_pro)
					->setCellValue('D' . $Ct, $pro->tld_nom_edf)
					->setCellValue('E' . $Ct, $pro->tld_num_prp)
					->setCellValue('F' . $Ct, $pro->tld_trr_prp)
					->setCellValue('G' . $Ct, $pro->tld_val_arr)
					->setCellValue('H' . $Ct, $pro->tld_abn_gar)
					->setCellValue('I' . $Ct, $pro->tld_gto_com)
					->setCellValue('J' . $Ct, $pro->tld_gto_agu)
					->setCellValue('K' . $Ct, $pro->tld_gto_luz)
					->setCellValue('L' . $Ct, $pro->tld_gto_ctr)
					->setCellValue('M' . $Ct, $pro->tld_gto_lim)
					->setCellValue('N' . $Ct, $pro->tld_gto_mul)
					->setCellValue('O' . $Ct, $pro->tld_gto_arr)
					->setCellValue('P' . $Ct, $pro->tld_dev_gar)
					->setCellValue('Q' . $Ct, $pro->tld_pgo_adm)
					->setCellValue('R' . $Ct, $pro->tld_iva_adm)
					->setCellValue('S' . $Ct, $pro->tld_pgo_com)
					->setCellValue('T' . $Ct, $pro->tld_iva_com)
					->setCellValue('U' . $Ct, $pro->tld_tot_fin);

			/*Separador de miles*/
			$objPHPExcel->getActiveSheet()->getStyle('G' . $Ct . ':U' . $Ct )->getNumberFormat()->setFormatCode('$#,##0;[Red]-$#,##0'); 
			
			/*Centrar Celdas*/       
			$objPHPExcel->getActiveSheet()->getStyle('G' . $Ct . ':U' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$objPHPExcel->getActiveSheet()->getStyle('B' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objPHPExcel->getActiveSheet()->getStyle('E' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objPHPExcel->getActiveSheet()->getStyle('F' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		}   
				      
		$objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
		//Unir celdas 
		$objPHPExcel->getActiveSheet()->mergeCells('B2:E2');
		     
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('U')->setAutoSize(true);
			    
		$objPHPExcel->getActiveSheet()->setTitle('Exportacion');
		$objPHPExcel->setActiveSheetIndex(0);         
		
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="Listado_de_Periodo_por_Due�os_de_Propiedades.xls"');
		header('Cache-Control: max-age=0');
		header('Cache-Control: max-age=1');       
		
		header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
		header ('Cache-Control: cache, must-revalidate');
		header ('Pragma: public'); // HTTP/1.0

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');
	}

		

}