<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

if(!function_exists('fcf_cmb_fec_dtm'))
{
    /**
     * Función que devuelve fecha formateada YYYY-MM-DD 00:00:00
     *
     * @param $string
     *  string la cadena a sanear
     *
     * @return $string
     *  string saneada
     */
    function fcf_cmb_fec_dtm($oldDate, $iTipSal)
    {           
        $arr = explode(' ', $oldDate);        
        //YYYY-MM-DD  00:00:00
        $sFec = explode('-', $arr[0]);             

        if ($iTipSal == 1){
            return $sFec[2] . '-' . $sFec[1] . '-' . $sFec[0];
        }elseif ($iTipSal == 2) {
                # code...
                return $sFec[2] . '-' . $sFec[1] . '-' . $sFec[0] . ' ' . $arr[1];        
        }        
    }
}

if(!function_exists('fcf_cmb_fec'))
{
    /**
     * Función que devuelve fecha formateada YYYY-MM-DD
     *
     * @param $string
     *  string la cadena a sanear
     *
     * @return $string
     *  string saneada
     */
    function fcf_cmb_fec($oldDate)
    {           
        $arr = explode('-', $oldDate);        
     
        return $arr[2] . '-' . $arr[1] . '-' . $arr[0];
    }

}

if(!function_exists('rpz_ace_word'))
{
	/**
	 * Reemplaza todos los acentos que llegan en mayusculas y los comvierte a minusculas
	 *
	 * @param $string
	 *  string la cadena a sanear
	 *
	 * @return $string
	 *  string saneada
	 */
	function rpz_ace_word($string)
	{
	 
	    $string = trim($string);
	 
	    $string = str_replace(
	        array('Á', 'É', 'Í', 'Ó', 'Ú', 'Ñ'),
	        array('á', 'é', 'í', 'ó', 'ú', 'ñ'),
	        $string
	    );	 
	 
	    return utf8_decode($string);
	}

}

if(!function_exists('limpiar_caracteres_especiales'))
{
    /**
     * 
     *
     * @param $string
     *  string la cadena a sanear
     *
     * @return $string
     *  string saneada
     */

    function limpiar_caracteres_especiales($s) 
    {

        $s = str_replace("[áàâãª]","a",$s);
        $s = str_replace("[ÁÀÂÃ]","A",$s);
        $s = str_replace("[éèê]","e",$s);
        $s = str_replace("[ÉÈÊ]","E",$s);
        $s = str_replace("[íìî]","i",$s);
        $s = str_replace("[ÍÌÎ]","I",$s);
        $s = str_replace("[óòôõº]","o",$s);
        $s = str_replace("[ÓÒÔÕ]","O",$s);
        $s = str_replace("[úùû]","u",$s);
        $s = str_replace("[ÚÙÛ]","U",$s);
       //$s = str_replace(" ","-",$s);
        $s = str_replace("ñ","n",$s);
        $s = str_replace("Ñ","N",$s);
        //para ampliar los caracteres a reemplazar agregar lineas de este tipo:
        //$s = str_replace("caracter-que-queremos-cambiar","caracter-por-el-cual-lo-vamos-a-cambiar",$s);
        return $s;
    }

}

function normaliza ($cadena){
    $originales = 'ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûýýþÿŔŕ';
    $modificadas = 'aaaaaaaceeeeiiiidnoooooouuuuybsaaaaaaaceeeeiiiidnoooooouuuyybyRr';
    $cadena = utf8_decode($cadena);
    $cadena = strtr($cadena, utf8_decode($originales), $modificadas);
    $cadena = strtolower($cadena);

    return utf8_encode($cadena);
}

if(!function_exists('normalizaArcAdj'))
{
    /**
     * Reemplaza texto con caracteres extraños
     *
     * @param $string
     *  string la cadena a sanear
     *
     * @return $string
     *  string saneada
     */

        function normalizaArcAdj($cadena){

            $originales  = ' ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûýýþÿŔŕÑñ°.';
            $modificadas = '_aaaaaaaceeeeiiiidnoooooouuuuybsaaaaaaaceeeeiiiidnoooooouuuyybyRrNn_';
            $cadena = utf8_decode($cadena);
            $cadena = strtr($cadena, utf8_decode($originales), $modificadas);
        
            return utf8_encode($cadena);
        }
}

        /*$file_name = str_replace("Ã¡", "a", $file_name);
        $file_name = str_replace("Ã©", "e", $file_name);
        $file_name = str_replace("Ã­", "i", $file_name);
        $file_name = str_replace("Ã³", "o", $file_name);
        $file_name = str_replace("Ãº", "u", $file_name);*/

if(!function_exists('pri_may_min'))
{
    /**
     * Reemplaza texto mayuscula a minuscula, dejando la primera letra en mayuscula
     *
     * @param $string
     *  string la cadena a sanear
     *
     * @return $string
     *  string saneada
     */
    function pri_may_min($string)
    {
     
        $string = trim($string);
     
        $string = ucwords(strtolower($string));       
        //$string = ucwords(strtolower(rpz_ace_word($string)));       
     
        return utf8_decode($string);
    }

}

if(!function_exists('formato_fecha'))
{
	//formateamos la fecha en 05 de marzo 2017,
	 function formato_fecha($fecha,$iVal){

	        $dia = substr($fecha, 0, 2);
	        $mes = substr($fecha, 3, 2);        
	        $ano = substr($fecha, -4);

	        switch ($mes) {
	            case '01':
	                $mes = 'Enero';
	                break;
	            case '02':
	                $mes = 'Febrero';
	                break;
	            case '03':
	                $mes = 'Marzo';
	                break;
	            case '04':
	                $mes = 'Abril';
	                break;
	            case '05':
	                $mes = 'Mayo';
	                break;
	            case '06':
	                $mes = 'Junio';
	                break;
	            case '07':
	                $mes = 'Julio';
	                break;
	            case '08':
	                $mes = 'Agosto';
	                break;
	            case '09':
	                $mes = 'Septiembre';
	                break;
	            case '10':
	                $mes = 'Octubre';
	                break;
	            case '11':
	                $mes = 'Noviembre';
	                break;
	            case '12':
	                $mes = 'Diciembre';
	                break;
	            
	            default:
	                $mes = 'Otro Mes';
	                break;
	        }

            switch($iVal){
                
                case '1':
                    $iRtnfecha = $dia . ' de ' . $mes . ' de ' . $ano;
                break;
                case '2':
                    $iRtnfecha = fnc_num_enn_pal($dia) . ' de ' . $mes . ' del año ' . fnc_num_enn_pal($ano);
                    //veinte y cuatro de Julio del año dos mil catorce
                break;
                case '3':
                    $iRtnfecha = fnc_num_enn_pal($dia) . ' de ' . $mes . ' de ' . fnc_num_enn_pal($ano);
                    //veinte y cuatro de Julio de dos mil catorce
                break;
                case '4':
                    $iRtnfecha = $mes . ' de ' . fnc_num_enn_pal($ano);
                    //Mayo de dos mil doce
                break;

            }
           	        
	        return $iRtnfecha;
	    }
}

function fnc_rut_con_pal($Rut)
{    

    $strArray = explode("-",$Rut);

    if ($strArray[1] === "k" Or $strArray[1] === "K")
    {
        $iRutArr = fnc_num_enn_pal($strArray[0]) . " guión k";
    } else{

        $iRutArr = fnc_num_enn_pal($strArray[0]) . " guión " . fnc_num_enn_pal($strArray[1]);
    }       
    
    return  $iRutArr;
}

function fnc_nom_mes_enn_pal($mes){

 setlocale(LC_TIME, 'spanish');   
 $nombre=strftime("%B",mktime(0, 0, 0, $mes, 1, 2000)); 

 return $nombre;

} 


if(!function_exists('fnc_num_enn_pal'))
{
 //------    CONVERTIR NUMEROS A LETRAS         ---------------
    //------    Máxima cifra soportada: 18 dígitos con 2 decimales
    //------    999,999,999,999,999,999.99
    // NOVECIENTOS NOVENTA Y NUEVE MIL NOVECIENTOS NOVENTA Y NUEVE BILLONES
    // NOVECIENTOS NOVENTA Y NUEVE MIL NOVECIENTOS NOVENTA Y NUEVE MILLONES
    // NOVECIENTOS NOVENTA Y NUEVE MIL NOVECIENTOS NOVENTA Y NUEVE PESOS 99/100 M.N.
    //------    Creada por:                        ---------------
    //------             ULTIMINIO RAMOS GALÁN     ---------------
    //------            uramos@gmail.com           ---------------
    //------    10 de junio de 2009. México, D.F.  ---------------
    //------    PHP Version 4.3.1 o mayores (aunque podría funcionar en versiones anteriores, tendrías que probar)

    function fnc_num_enn_pal($xcifra)
    {
        $xarray = array(0 => "Cero",
            1 => "UNO", "DOS", "TRES", "CUATRO", "CINCO", "SEIS", "SIETE", "OCHO", "NUEVE",
            "DIEZ", "ONCE", "DOCE", "TRECE", "CATORCE", "QUINCE", "DIECISéIS", "DIECISIETE", "DIECIOCHO", "DIECINUEVE",
            "VEINTI", 30 => "TREINTA", 40 => "CUARENTA", 50 => "CINCUENTA", 60 => "SESENTA", 70 => "SETENTA", 80 => "OCHENTA", 90 => "NOVENTA",
            100 => "CIENTO", 200 => "DOSCIENTOS", 300 => "TRESCIENTOS", 400 => "CUATROCIENTOS", 500 => "QUINIENTOS", 600 => "SEISCIENTOS", 700 => "SETECIENTOS", 800 => "OCHOCIENTOS", 900 => "NOVECIENTOS"
        );
    //
        $xcifra = trim($xcifra);
        $xlength = strlen($xcifra);
        $xpos_punto = strpos($xcifra, ".");
        $xaux_int = $xcifra;
        $xdecimales = "00";
        if (!($xpos_punto === false)) {
            if ($xpos_punto == 0) {
                $xcifra = "0" . $xcifra;
                $xpos_punto = strpos($xcifra, ".");
            }
            $xaux_int = substr($xcifra, 0, $xpos_punto); // obtengo el entero de la cifra a covertir
            $xdecimales = substr($xcifra . "00", $xpos_punto + 1, 2); // obtengo los valores decimales
        }
     
        $XAUX = str_pad($xaux_int, 18, " ", STR_PAD_LEFT); // ajusto la longitud de la cifra, para que sea divisible por centenas de miles (grupos de 6)
        $xcadena = "";
        for ($xz = 0; $xz < 3; $xz++) {
            $xaux = substr($XAUX, $xz * 6, 6);
            $xi = 0;
            $xlimite = 6; // inicializo el contador de centenas xi y establezco el límite a 6 dígitos en la parte entera
            $xexit = true; // bandera para controlar el ciclo del While
            while ($xexit) {
                if ($xi == $xlimite) { // si ya llegó al límite máximo de enteros
                    break; // termina el ciclo
                }
     
                $x3digitos = ($xlimite - $xi) * -1; // comienzo con los tres primeros digitos de la cifra, comenzando por la izquierda
                $xaux = substr($xaux, $x3digitos, abs($x3digitos)); // obtengo la centena (los tres dígitos)
                for ($xy = 1; $xy < 4; $xy++) { // ciclo para revisar centenas, decenas y unidades, en ese orden
                    switch ($xy) {
                        case 1: // checa las centenas
                            if (substr($xaux, 0, 3) < 100) { // si el grupo de tres dígitos es menor a una centena ( < 99) no hace nada y pasa a revisar las decenas
                                 
                            } else {
                                $key = (int) substr($xaux, 0, 3);
                                if (TRUE === array_key_exists($key, $xarray)){  // busco si la centena es número redondo (100, 200, 300, 400, etc..)
                                    $xseek = $xarray[$key];
                                    $xsub = subfijo($xaux); // devuelve el subfijo correspondiente (Millón, Millones, Mil o nada)
                                    if (substr($xaux, 0, 3) == 100)
                                        $xcadena = " " . $xcadena . " CIEN " . $xsub;
                                    else
                                        $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                                    $xy = 3; // la centena fue redonda, entonces termino el ciclo del for y ya no reviso decenas ni unidades
                                }
                                else { // entra aquí si la centena no fue numero redondo (101, 253, 120, 980, etc.)
                                    $key = (int) substr($xaux, 0, 1) * 100;
                                    $xseek = $xarray[$key]; // toma el primer caracter de la centena y lo multiplica por cien y lo busca en el arreglo (para que busque 100,200,300, etc)
                                    $xcadena = " " . $xcadena . " " . $xseek;
                                } // ENDIF ($xseek)
                            } // ENDIF (substr($xaux, 0, 3) < 100)
                            break;
                        case 2: // checa las decenas (con la misma lógica que las centenas)
                            if (substr($xaux, 1, 2) < 10) {
                                 
                            } else {
                                $key = (int) substr($xaux, 1, 2);
                                if (TRUE === array_key_exists($key, $xarray)) {
                                    $xseek = $xarray[$key];
                                    $xsub = subfijo($xaux);
                                    if (substr($xaux, 1, 2) == 20)
                                        $xcadena = " " . $xcadena . " VEINTE " . $xsub;
                                    else
                                        $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                                    $xy = 3;
                                }
                                else {
                                    $key = (int) substr($xaux, 1, 1) * 10;
                                    $xseek = $xarray[$key];
                                    if (20 == substr($xaux, 1, 1) * 10)
                                        $xcadena = " " . $xcadena . " " . $xseek;
                                    else
                                        $xcadena = " " . $xcadena . " " . $xseek . " Y ";
                                } // ENDIF ($xseek)
                            } // ENDIF (substr($xaux, 1, 2) < 10)
                            break;
                        case 3: // checa las unidades
                            if (substr($xaux, 2, 1) < 1) { // si la unidad es cero, ya no hace nada
                                 
                            } else {
                                $key = (int) substr($xaux, 2, 1);
                                $xseek = $xarray[$key]; // obtengo directamente el valor de la unidad (del uno al nueve)
                                $xsub = subfijo($xaux);
                                $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                            } // ENDIF (substr($xaux, 2, 1) < 1)
                            break;
                    } // END SWITCH
                } // END FOR
                $xi = $xi + 3;
            } // ENDDO
     
            if (substr(trim($xcadena), -5, 5) == "ILLON") // si la cadena obtenida termina en MILLON o BILLON, entonces le agrega al final la conjuncion DE
                $xcadena.= " DE";
     
            if (substr(trim($xcadena), -7, 7) == "ILLONES") // si la cadena obtenida en MILLONES o BILLONES, entoncea le agrega al final la conjuncion DE
                $xcadena.= " DE";
     
            // ----------- esta línea la puedes cambiar de acuerdo a tus necesidades o a tu país -------
            if (trim($xaux) != "") {
                switch ($xz) {
                    case 0:
                        if (trim(substr($XAUX, $xz * 6, 6)) == "1")
                            $xcadena.= "UN BILLON ";
                        else
                            $xcadena.= " BILLONES ";
                        break;
                    case 1:
                        if (trim(substr($XAUX, $xz * 6, 6)) == "1")
                            $xcadena.= "UN MILLON ";
                        else
                            $xcadena.= " MILLONES ";
                        break;
                    case 2:
                        /*if ($xcifra < 1) {
                            $xcadena = "CERO PESOS $xdecimales/100 M.N.";
                        }
                        if ($xcifra >= 1 && $xcifra < 2) {
                            $xcadena = "UN PESO $xdecimales/100 M.N. ";
                        }
                        if ($xcifra >= 2) {
                            $xcadena.= " PESOS $xdecimales/100 M.N. "; //
                        }*/
                        /*if ($xcifra < 1) {
                            $xcadena = "CERO PESOS";
                        }
                        if ($xcifra >= 1 && $xcifra < 2) {
                            $xcadena = "UN PESO";
                        }
                        if ($xcifra >= 2) {
                            $xcadena.= " PESOS"; //
                        }*/
                        if ($xcifra < 1) {
                            $xcadena = "CERO";
                        }
                        if ($xcifra >= 1 && $xcifra < 2) {
                            $xcadena = "UNO";
                        }
                        if ($xcifra >= 2) {
                            $xcadena.= " "; //
                        }
                        break;
                        break;
                } // endswitch ($xz)
            } // ENDIF (trim($xaux) != "")
            // ------------------      en este caso, para México se usa esta leyenda     ----------------
            $xcadena = str_replace("VEINTI ", "VEINTI", $xcadena); // quito el espacio para el VEINTI, para que quede: VEINTICUATRO, VEINTIUN, VEINTIDOS, etc
            $xcadena = str_replace("  ", " ", $xcadena); // quito espacios dobles
            $xcadena = str_replace("UN UN", "UN", $xcadena); // quito la duplicidad
            $xcadena = str_replace("  ", " ", $xcadena); // quito espacios dobles
            $xcadena = str_replace("BILLON DE MILLONES", "BILLON DE", $xcadena); // corrigo la leyenda
            $xcadena = str_replace("BILLONES DE MILLONES", "BILLONES DE", $xcadena); // corrigo la leyenda
            $xcadena = str_replace("DE UN", "UN", $xcadena); // corrigo la leyenda
        } // ENDFOR ($xz)
        return trim($xcadena);
    } 
    // END FUNCTION
}

if(!function_exists('subfijo'))
{
    function subfijo($xx)
    { // esta función regresa un subfijo para la cifra
        $xx = trim($xx);
        $xstrlen = strlen($xx);
        if ($xstrlen == 1 || $xstrlen == 2 || $xstrlen == 3)
            $xsub = "";
        //
        if ($xstrlen == 4 || $xstrlen == 5 || $xstrlen == 6)
            $xsub = "MIL";
        //
        return $xsub;
    } 
    // END FUNCTION
}

if(!function_exists('Fnc_Csu_Val_Tab'))
{
    /**
     *  Trae la descripción del tablón según el grupo
     *
     * @param $string
     *  string la cadena a sanear
     *
     * @return $string
     *  string decripción del grupo
     */
    function Fnc_Csu_Val_Tab($iCodGrp)
    {     
        //asignamos a $ci el super objeto de codeigniter
        //$ci será como $this
        $ci =& get_instance();
        
        $ci->db->select('ttg_cod_idd,ttg_des_gnr');
        $ci->db->where('ttg_cod_grp',$iCodGrp);        

        return $ci->db->get('tab_tbl_gnr')->result();                               
    }
}

if(!function_exists('Fnc_Csu_Cmp_Tab'))
{
    /**
     *  Trae la campo según parametro
     *
     * @param $string
     *  string la cadena a sanear
     *
     * @return $string
     *  string decripción del grupo
     */
    function Fnc_Csu_Cmp_Tab($tabla,$select,$where,$iCodOrg)
    {     
        //asignamos a $ci el super objeto de codeigniter
        //$ci será como $this
        $ci =& get_instance();                  

        $ci->db->select($select . ' as tmp_cmp_gnr');        
        $ci->db->where(array($where => $iCodOrg));  

        $query = $ci->db->get($tabla);    

        if(!$query->num_rows() == 1)
        {
            return false;
        }

        return $query->row();         
    }
}



if(!function_exists('fnc_eli_adj_adj'))
{
    /**
     *  Eliminar archivo adjunto
     *
     * @param $string
     *  ruta
     *
     * @return $string
     *  string 
     */
    function fnc_eli_adj_adj($ruta,$arc_adj)
    {
     
        for($i=0;$i<count($arc_adj);$i++)
        {            
            unlink(APPPATH . '../../archivos/' . $ruta . '/' . $arc_adj[$i]);
        }         
    }      
}

if(!function_exists('groupArray'))
{
    /**
     *  Agrupacion por campo
     *
     * @param $array @string
     *  
     *
     * @return $array
     *  array 
     */

    function groupArray($array,$groupkey)
    {
        if (count($array)>0)
        {
            $keys = array_keys($array[0]);
            $removekey = array_search($groupkey, $keys);

            if ($removekey===false){
                return array("Clave \"$groupkey\" no existe");
            }
            else{
                unset($keys[$removekey]);
            }

            $groupcriteria = array();
            $return=array();

            foreach($array as $value)
            {
                $item=null;
                foreach ($keys as $key)
                {
                    $item[$key] = $value[$key];
                }

                $busca = array_search($value[$groupkey], $groupcriteria);
                if ($busca === false)
                {
                    $groupcriteria[]=$value[$groupkey];
                    $return[]=array($groupkey=>$value[$groupkey],'groupeddata'=>array());
                    $busca=count($return)-1;
                }
                $return[$busca]['groupeddata'][]=$item;
            }
            return $return;
        }
        else{
            return array();
        }
    }
}

if(!function_exists('fnc_ret_enc_itz'))
{
    /**
     *  Eliminar archivo adjunto
     *
     * @param $string
     *  ruta
     *
     * @return $string
     *  string 
     */
    function fnc_ret_enc_itz($objPHPExcel)
    {
     
        /*tamaño letra en la cabecera*/
        $objPHPExcel->getDefaultStyle()
                    ->getFont()                    
                    ->setName('Calibri')
                    ->setSize(8)
                    ->setBold(false)        
                    ->getColor();

       return $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A1', 'Código Plan de Cuenta')
                        ->setCellValue('B1', 'Monto al Debe Moneda Base')
                        ->setCellValue('C1', 'Monto al Haber Moneda Base')    
                        ->setCellValue('D1', 'Descripción Movimiento')  
                        ->setCellValue('E1', 'Ajuste 01/01/2013 referido al 31/12/2012')  
                        ->setCellValue('F1', 'Monto al Debe Moneda Adicional')  
                        ->setCellValue('G1', 'Monto al Haber Moneda Adicional')  
                        ->setCellValue('H1', 'Código Condición de Venta')  
                        ->setCellValue('I1', 'Código Vendedor')  
                        ->setCellValue('J1', 'Código Ubicación')  
                        ->setCellValue('K1', 'Código Concepto de Caja')
                        ->setCellValue('L1', 'Código Instrumento Financiero')
                        ->setCellValue('M1', 'Cantidad Instrumento Financiero')
                        ->setCellValue('N1', 'Código Detalle de Gasto')
                        ->setCellValue('O1', 'Cantidad Concepto de Gasto')
                        ->setCellValue('P1', 'Código Centro de Costo')
                        ->setCellValue('Q1', 'Tipo Docto. Conciliación')
                        ->setCellValue('R1', 'Nro. Docto. Conciliación')
                        ->setCellValue('S1', 'Código Auxiliar')
                        ->setCellValue('T1', 'Tipo Documento')
                        ->setCellValue('U1', 'Nro. Documento')
                        ->setCellValue('V1', 'Fecha Emisión Docto.')
                        ->setCellValue('W1', 'Fecha Vencimiento Docto.')
                        ->setCellValue('X1', 'Tipo Docto. Referencia')
                        ->setCellValue('Y1', 'Nro. Docto. Referencia')
                        ->setCellValue('Z1', 'Nro. Correlativo Interno')

                        ->setCellValue('AA1', 'Monto 1 Detalle Libro')
                        ->setCellValue('AB1', 'Monto 2 Detalle Libro')
                        ->setCellValue('AC1', 'Monto 3 Detalle Libro')
                        ->setCellValue('AD1', 'Monto 4 Detalle Libro')
                        ->setCellValue('AE1', 'Monto 5 Detalle Libro')
                        ->setCellValue('AF1', 'Monto 6 Detalle Libro')
                        ->setCellValue('AG1', 'Monto 7 Detalle Libro')
                        ->setCellValue('AH1', 'Monto 8 Detalle Libro')
                        ->setCellValue('AI1', 'Monto 9 Detalle Libro')
                        ->setCellValue('AJ1', 'Monto Suma Detalle Libro')
                        ->setCellValue('AK1', 'Graba el detalle de libro (S/N) (Por defecto "S")')
                        ->setCellValue('AL1', 'Documento Nulo (S/N) (Por defecto "N")')
                        ->setCellValue('AM1', 'Código flujo efectivo 1')
                        ->setCellValue('AN1', 'Monto flujo 1')
                        ->setCellValue('AO1', 'Código flujo efectivo 2')
                        ->setCellValue('AP1', 'Monto flujo 2')
                        ->setCellValue('AQ1', 'Código flujo efectivo 3')
                        ->setCellValue('AR1', 'Monto flujo 3')
                        ->setCellValue('AS1', 'Código flujo efectivo 4')
                        ->setCellValue('AT1', 'Monto flujo 4')
                        ->setCellValue('AU1', 'Código flujo efectivo 5')
                        ->setCellValue('AV1', 'Monto flujo 5')
                        ->setCellValue('AW1', 'Código flujo efectivo 6')
                        ->setCellValue('AX1', 'Monto flujo 6')
                        ->setCellValue('AY1', 'Código flujo efectivo 7')
                        ->setCellValue('AZ1', 'Monto flujo 7')

                        ->setCellValue('BA1', 'Código flujo efectivo 8')
                        ->setCellValue('BB1', 'Monto flujo 8')
                        ->setCellValue('BC1', 'Código flujo efectivo 9')
                        ->setCellValue('BD1', 'Monto flujo 9')
                        ->setCellValue('BE1', 'Código flujo efectivo 10')
                        ->setCellValue('BF1', 'Monto flujo 10');             
    }      
}

//end application/helpers/fnc_gnr_helper.php