<?php 
include 'enableCORS.php';
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Cls_adm_pro extends CI_Controller {


	Public function __construct(){

	enableCORS(); 
	parent::__construct();
	/* CARGAMOS LIBRERIAS PARA ESTE CONTROLLER*/       
	include(dirname(__FILE__)."/../libraries/PHPExcel/Classes/PHPExcel.php");      
	include(dirname(__FILE__)."/../libraries/MPDF54/mpdf.php");
	$this->load->model(array('mdl_exp_exc')); 
	$this->load->model(array('mdl_exp_pdf')); 

	}
	
	
	Public Function fnc_csu_adm_pro()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  
		
		ini_set("memory_limit", "-1");
		set_time_limit(0);	

		/*[AUT-20180114 : Parametros de Entrada desde ExtJS]*/
		$iPerCtr = $data[0];
		$iOpcRpt = $data[1];

		/*[AUT-20180114 : Reemplazo de ap�strofe para par�metros de Entrada desde ExtJS]*/
		$iOpcRpt = str_replace("'", "�", $iOpcRpt);

		/*[AUT-20180114 : Formaci�n de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim(strtoupper($iPerCtr));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iOpcRpt));

		/*[AUT-20180114 : Llamada al Servicio MySQL]*/	
		$sSql = "svc_csu_adm_pro";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}
		
		echo json_encode(
			    array(
			      'success'  => true,
			      'data'     => $data                     
			    )
		);  
	}





	Public Function fnc_exp_exc_pro()
	{
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/        
		$data = json_decode($this->input->get('jObject'), true);  						
		
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/
		$iPerCtr = $data[0];
		$iOpcRpt = $data[1];
		
		/** CABECERAS **/
		error_reporting(E_ALL);
		ini_set('display_errors', TRUE);
		ini_set('display_startup_errors', TRUE);   

		ini_set("memory_limit", "-1");
		set_time_limit(0);		
		
		//NUEVO OBJETO GENERAL
		$objPHPExcel = new PHPExcel();
		

		//PROPIEDADES METADATOS
		$objPHPExcel->getProperties()->setCreator("Contacar")
					     ->setLastModifiedBy("Operador de Contacar")
					     ->setTitle("Office Exportacion")
					     ->setSubject("Office Exportacion")
					     ->setDescription("Office Exportacion")
					     ->setKeywords("office 2007 openxml php")
					     ->setCategory("Office Exportacion");                                      
		
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Reporte Mensual de Comisiones por Administracion y Arriendo');        
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B2')
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(15)
			    ->setBold(true)
			    ->getColor();        
		       
		/*Centrar Celdas*/            
		$objPHPExcel->getActiveSheet()->getStyle('B5:I5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
		$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('B5', 'Propietario')
			    ->setCellValue('C5', 'Tipo de Propiedad')
			    ->setCellValue('D5', 'Comision por Administracion')
			    ->setCellValue('E5', 'IVA 19% Com. Administracion')
			    ->setCellValue('F5', 'Total Com. Administracion')
			    ->setCellValue('G5', 'Comisi�n por Arriendo')
			    ->setCellValue('H5', 'IVA 19% Com. Arriendo')
			    ->setCellValue('I5', 'Total Com. Arriendo');
			    
		//Configuraci�n de tipos de letra                         
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B5:I5')
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(true)        
			    ->getColor()
			    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
			    
		//fondo a celda
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B5:I5')
			    ->getFill()
			    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
			    ->getStartColor()
			    ->setARGB('&H808080');         

		$csu_adm_pro = $this
                        ->mdl_exp_exc
                        ->mdl_csu_adm_pro($iPerCtr,$iOpcRpt);  

		$Ct = 5;		
		
		/*tama�o letra en grilla*/
		$objPHPExcel->getDefaultStyle()
			    ->getFont()                    
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(false)        
			    ->getColor();   
		   
		foreach ($csu_adm_pro as $pro)
		{
			$Ct = $Ct + 1;
			
			$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('B' . $Ct, $pro->tmp_nom_pro)
					->setCellValue('C' . $Ct, $pro->tld_tip_prp)
					->setCellValue('D' . $Ct, $pro->tld_pgo_adm)
					->setCellValue('E' . $Ct, $pro->tld_iva_adm)
					->setCellValue('F' . $Ct, $pro->tld_tot_adm)
					->setCellValue('G' . $Ct, $pro->tld_pgo_com)
					->setCellValue('H' . $Ct, $pro->tld_iva_com)
					->setCellValue('I' . $Ct, $pro->tld_tot_com);

			/*Separador de miles*/
			$objPHPExcel->getActiveSheet()->getStyle('D' . $Ct . ':I' . $Ct )->getNumberFormat()->setFormatCode('$#,##0;[Red]-$#,##0'); 
			
			/*Centrar Celdas*/       
			$objPHPExcel->getActiveSheet()->getStyle('D' . $Ct . ':I' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
		}   
				      
		$objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
		//Unir celdas 
		$objPHPExcel->getActiveSheet()->mergeCells('B2:E2');
		     
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
			    
		$objPHPExcel->getActiveSheet()->setTitle('Exportacion');
		$objPHPExcel->setActiveSheetIndex(0);         
		
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="Listado_de_Reporte_Mensual_de_Comisiones_por_Administracion_y_Arriendo.xls"');
		header('Cache-Control: max-age=0');
		header('Cache-Control: max-age=1');       
		
		header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
		header ('Cache-Control: cache, must-revalidate');
		header ('Pragma: public'); // HTTP/1.0

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');
	}
	
	
	
	Public function fnc_csu_pro_pdf()
	{
	
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/        
		$data = json_decode($this->input->get('jObject'), true); 		

		ini_set("memory_limit", "-1");
		set_time_limit(0);	
		
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/
		$iPerCtr = $data[0];
		$iOpcRpt = $data[1];
	
		$csu_adm_pro = $this->mdl_exp_pdf->mdl_csu_adm_pro($iPerCtr,$iOpcRpt);
	
		$extmod_str    =implode("",file(dirname(__FILE__).'/../../contents/html-rpt-adm.htm'));
		$extmod_str_enc=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-adm-enc.htm'));	
		$extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-adm-det.htm'));
		$extmod_str_tot=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-adm-tot.htm'));
		$extmod_str_fnl=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-adm-fnl.htm'));		
		
		$img_log_goo = '<img  src="'. APPPATH . '../../archivos/logo/logo.png" width="150" height="44" alt="Logo"/>';
		$extmod_str=str_replace('@@img-log-cli', $img_log_goo, $extmod_str);
		
		$cnt_tot_pro = 0;
		$tmp_cod_pro = 0;
		
		foreach ($csu_adm_pro as $row)
		{

			$extmod_str=str_replace('@@csu_fec_sys',     $row->csu_fec_sys, $extmod_str);
			$extmod_str=str_replace('@@csu_hor_sys',     $row->csu_hor_sys, $extmod_str);
			
			if ($tmp_cod_pro != $row->tmp_cod_pro) {
				$tmp_cod_pro = $row->tmp_cod_pro;
				
				$extmod_str_enc=str_replace('@@tmp_nom_pro', $row->tmp_nom_pro, $extmod_str_enc);
				$cnt_tot_pro = 0;
				$adj_adm_det = "";
				$adj_adm_tot = 0;
				
				$tot_pgo_adm = 0;
				$tot_iva_adm = 0;
				$tot_tot_adm = 0;
				$tot_pgo_com = 0;
				$tot_iva_com = 0;
				$tot_tot_com = 0;
				foreach ($csu_adm_pro as $det)
				{	
					if($tmp_cod_pro == $det->tmp_cod_pro){
						$extmod_str_det=str_replace('@@tld_tip_prp', $det->tld_tip_prp, $extmod_str_det);
						$extmod_str_det=str_replace('@@tld_pgo_adm', $det->tmp_pgo_adm, $extmod_str_det);
						$extmod_str_det=str_replace('@@tld_iva_adm', $det->tmp_iva_adm, $extmod_str_det);
						$extmod_str_det=str_replace('@@tld_tot_adm', $det->tmp_tot_adm, $extmod_str_det);
						$extmod_str_det=str_replace('@@tld_pgo_com', $det->tmp_pgo_com, $extmod_str_det);
						$extmod_str_det=str_replace('@@tld_iva_com', $det->tmp_iva_com, $extmod_str_det);
						$extmod_str_det=str_replace('@@tld_tot_com', $det->tmp_tot_com, $extmod_str_det);
	
						$adj_adm_det = $adj_adm_det . $extmod_str_det;
						
						$tot_pgo_adm = $tot_pgo_adm + $det->tld_pgo_adm;
						$tot_iva_adm = $tot_iva_adm + $det->tld_iva_adm;
						$tot_tot_adm = $tot_tot_adm + $det->tld_tot_adm;
						
						$tot_pgo_com = $tot_pgo_com + $det->tld_pgo_com;
						$tot_iva_com = $tot_iva_com + $det->tld_iva_com;
						$tot_tot_com = $tot_tot_com + $det->tld_tot_com;

						$cnt_tot_pro = $cnt_tot_pro + 1;	
					}
					$extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-adm-det.htm'));
				}
				
				$fnl_pgo_adm = $fnl_pgo_adm + $tot_pgo_adm;
				$fnl_iva_adm = $fnl_iva_adm + $tot_iva_adm;
				$fnl_tot_adm = $fnl_tot_adm + $tot_tot_adm;
				
				$fnl_pgo_com = $fnl_pgo_com + $tot_pgo_com;
				$fnl_iva_com = $fnl_iva_com + $tot_iva_com;
				$fnl_tot_com = $fnl_tot_com + $tot_tot_com;
				
				$tot_pgo_adm = number_format($tot_pgo_adm,0);
				$tot_iva_adm = number_format($tot_iva_adm,0);
				$tot_tot_adm = number_format($tot_tot_adm,0);
				$tot_pgo_com = number_format($tot_pgo_com,0);
				$tot_iva_com = number_format($tot_iva_com,0);
				$tot_tot_com = number_format($tot_tot_com,0);
				
				$tot_pgo_adm = str_replace(",", ".", $tot_pgo_adm);
				$tot_iva_adm = str_replace(",", ".", $tot_iva_adm);
				$tot_tot_adm = str_replace(",", ".", $tot_tot_adm);
				$tot_pgo_com = str_replace(",", ".", $tot_pgo_com);
				$tot_iva_com = str_replace(",", ".", $tot_iva_com);
				$tot_tot_com = str_replace(",", ".", $tot_tot_com);
				
				$extmod_str_tot=str_replace('@@tot_pgo_adm', '$ '.$tot_pgo_adm, $extmod_str_tot);
				$extmod_str_tot=str_replace('@@tot_iva_adm', '$ '.$tot_iva_adm, $extmod_str_tot);
				$extmod_str_tot=str_replace('@@tot_tot_adm', '$ '.$tot_tot_adm, $extmod_str_tot);
				
				$extmod_str_tot=str_replace('@@tot_pgo_com', '$ '.$tot_pgo_com, $extmod_str_tot);
				$extmod_str_tot=str_replace('@@tot_iva_com', '$ '.$tot_iva_com, $extmod_str_tot);
				$extmod_str_tot=str_replace('@@tot_tot_com', '$ '.$tot_tot_com, $extmod_str_tot);
				
				$adj_adm_tot = $adj_adm_tot . $extmod_str_tot;
				
				$extmod_str_tot=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-adm-tot.htm'));
				
				$extmod_str_enc=str_replace('@@cnt_tot_pro', $cnt_tot_pro, $extmod_str_enc);
				
				$adj_dev_enc = $adj_dev_enc . $extmod_str_enc . $adj_adm_det .$adj_adm_tot;
				$extmod_str_enc=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-adm-enc.htm'));
			
			}

		}

		
		if($cnt_tot_pro == 0){
			$extmod_str=str_replace('@@csu_fec_sys',     '', $extmod_str);
			$extmod_str=str_replace('@@csu_hor_sys',     '', $extmod_str);
			$extmod_str=str_replace('@@var_glb_reg',     'No se encontraron datos a imprimir', $extmod_str);
		}
		else{
			$extmod_str=str_replace('@@var_glb_reg',     '', $extmod_str);
		}
		
		$fnl_pgo_adm = number_format($fnl_pgo_adm,0);
		$fnl_iva_adm = number_format($fnl_iva_adm,0);
		$fnl_tot_adm = number_format($fnl_tot_adm,0);
		$fnl_pgo_com = number_format($fnl_pgo_com,0);
		$fnl_iva_com = number_format($fnl_iva_com,0);
		$fnl_tot_com = number_format($fnl_tot_com,0);
		
		$fnl_pgo_adm = str_replace(",", ".", $fnl_pgo_adm);
		$fnl_iva_adm = str_replace(",", ".", $fnl_iva_adm);
		$fnl_tot_adm = str_replace(",", ".", $fnl_tot_adm);
		$fnl_pgo_com = str_replace(",", ".", $fnl_pgo_com);
		$fnl_iva_com = str_replace(",", ".", $fnl_iva_com);
		$fnl_tot_com = str_replace(",", ".", $fnl_tot_com);
		
		$extmod_str_fnl=str_replace('@@fnl_pgo_adm', $fnl_pgo_adm, $extmod_str_fnl);
		$extmod_str_fnl=str_replace('@@fnl_iva_adm', $fnl_iva_adm, $extmod_str_fnl);
		$extmod_str_fnl=str_replace('@@fnl_tot_adm', $fnl_tot_adm, $extmod_str_fnl);
		$extmod_str_fnl=str_replace('@@fnl_pgo_com', $fnl_pgo_com, $extmod_str_fnl);
		$extmod_str_fnl=str_replace('@@fnl_iva_com', $fnl_iva_com, $extmod_str_fnl);
		$extmod_str_fnl=str_replace('@@fnl_tot_com', $fnl_tot_com, $extmod_str_fnl);
		
		$extmod_str=str_replace('@@html-rpt-adm-enc', $adj_dev_enc .$extmod_str_fnl, $extmod_str);
		
		//configuramos PDF
		$mpdf= new mPDF(
			'',    // mode - default ''
			'',    // format - A4, for example, default ''
			0,     // font size - default 0
			'',    // default font family
			15,    // margin_left
			15,    // margin right
			16,    // margin top
			16,    // margin bottom
			9,     // margin header
			9,     // margin footer
			'L'    // L - landscape, P - portrait
			);			
		
		$mpdf->SetHTMLFooter('<hr align="center"; width="100% "; noshade; color=#9F9F9F><table width="100%" style="vertical-align: bottom; font-family: tahoma,geneva,sans-serif; font-size: 8pt; color: #9F9F9F; "><tr> <td width="50%" style="text-align: left;">Informe Mensual de Comision de Administracion y Arriendo</td> <td width="50%" align="right";>{PAGENO}/{nbpg}</td> </tr></table>');
		//$mpdf->SetHTMLFooter('<hr align="center"; width="100% "; noshade; color=#9F9F9F><table width="100%" style="vertical-align: bottom; font-family: tahoma,geneva,sans-serif; font-size: 8pt; color: #9F9F9F; "><tr> <td width="33%"><span>{DATE j-m-Y}</span></td> <td width="30%" align="center" >{PAGENO}/{nbpg}</td> <td width="37%" style="text-align: left; ">Banco de Chile - Departamento de Mantencion</td> </tr></table>');
		//$mpdf->setFooter("Banco de Chile - Departamento de Mantencion", 'E');
		$mpdf->WriteHTML($extmod_str);
		$mpdf->Output("Informe_Mensual_de_Comision_de_Administracion_y_Arriendo.pdf", "I");
	}
}