<?php 
include 'enableCORS.php';
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
    
class Cls_det_tcr extends CI_Controller {

	Public function __construct(){
		enableCORS(); 
		parent::__construct();
		/* CARGAMOS LIBRERIAS PARA ESTE CONTROLLER*/                
		include(dirname(__FILE__)."/../libraries/PHPExcel/Classes/PHPExcel.php");
		include(dirname(__FILE__)."/../libraries/MPDF54/mpdf.php");          
		$this->load->model(array('mdl_exp_exc'));
		$this->load->model(array('mdl_det_pry')); 		
	}
	
	Public Function fnc_grb_det_tcr()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  
				
		/*Se obtinene la fecha y hora para generar código interno*/
		$iKeyIdd = substr(Date('Ymdhis').microtime(),0,15);
		
		/*[AUT-20201219 : Parametros de Entrada desde ExtJS]*/
		$iCodDet = $data[0];
		$iCodCrd = $data[1];
		$iSdpOrg = $data[2];
		$iBcoOrg = $data[3];
		$iMtoOrg = $data[4];
		$iFecRtr = $data[5];
		$iRflOrg = $data[6];
		$iSdpDtn = $data[7];
		$iBcoDtn = $data[8];
		$iMtoDtn = $data[9];
		$iFecIng = $data[10];
		$iRflDtn = $data[11];
		$iDetCar = $data[12];

		/*[AUT-20201219 : Reemplazo de apóstrofe para parámetros de Entrada desde ExtJS]*/
		$iCodDet = str_replace("'", "´", $iCodDet);
		$iKeyIdd = str_replace("'", "´", $iKeyIdd);
		$iCodCrd = str_replace("'", "´", $iCodCrd);
		$iSdpOrg = str_replace("'", "´", $iSdpOrg);
		$iBcoOrg = str_replace("'", "´", $iBcoOrg);
		$iMtoOrg = str_replace("'", "´", $iMtoOrg);
		$iFecRtr = str_replace("'", "´", $iFecRtr);
		$iRflOrg = str_replace("'", "´", $iRflOrg);
		$iSdpDtn = str_replace("'", "´", $iSdpDtn);
		$iBcoDtn = str_replace("'", "´", $iBcoDtn);
		$iMtoDtn = str_replace("'", "´", $iMtoDtn);
		$iFecIng = str_replace("'", "´", $iFecIng);
		$iRflDtn = str_replace("'", "´", $iRflDtn);
		$iDetCar = str_replace("'", "´", $iDetCar);

		/*[AUT-20201219 : Formación de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim(strtoupper($iCodDet));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iKeyIdd)) . "'";
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodCrd));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iSdpOrg));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iBcoOrg));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iMtoOrg));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iFecRtr)) . "'";
		$iPrm = $iPrm . "   , " . trim(strtoupper($iRflOrg));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iSdpDtn));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iBcoDtn));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iMtoDtn));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iFecIng)) . "'";
		$iPrm = $iPrm . "   , " . trim(strtoupper($iRflDtn));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iDetCar)) . "'";

		/*[AUT-20201219 : Llamada al Servicio MySQL]*/	
		$sSql = "sva_grb_det_tcr";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}
		
        echo json_encode(
                    array(
                      'success'  => true,
                      'data'     => $data,
					  'e'        => $sExe                        
                    )
        );  
	}


	Public Function fnc_csu_det_tcr()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  
		
		/*[AUT-20201220 : Parametros de Entrada desde ExtJS]*/
		$iCodDet = $data[0];
		$iCodCrd = $data[1];

		/*[AUT-20201220 : Reemplazo de apóstrofe para parámetros de Entrada desde ExtJS]*/
		$iCodDet = str_replace("'", "´", $iCodDet);
		$iCodCrd = str_replace("'", "´", $iCodCrd);

		/*[AUT-20201220 : Formación de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim(strtoupper($iCodDet));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodCrd));

		/*[AUT-20201220 : Llamada al Servicio MySQL]*/	
		$sSql = "svc_csu_det_tcr";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}
		
        echo json_encode(
                    array(
                      'success'  => true,
                      'data'     => $data                 
                    )
        );  
	}
	
	
	Public Function fnc_eli_det_tcr()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  

		/*[AUT-20201220 : Parametros de Entrada desde ExtJS]*/
		$iCodDet = $data[0];
		$iCodCrd = $data[1];

		/*[AUT-20201220 : Reemplazo de apóstrofe para parámetros de Entrada desde ExtJS]*/
		$iCodDet = str_replace("'", "´", $iCodDet);
		$iCodCrd = str_replace("'", "´", $iCodCrd);

		/*[AUT-20201220 : Formación de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim(strtoupper($iCodDet));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodCrd));

		/*[AUT-20201220 : Llamada al Servicio MySQL]*/	
		$sSql = "sve_eli_det_tcr";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}
		
        echo json_encode(
                    array(
                      'success'  => true,
                      'data'     => $data                     
                    )
        );  
	}
	
	
	Public Function fnc_fto_det_tcr()
	{
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/        
		$data = json_decode($this->input->get('jObject'), true);  						
		
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/
		//$iCodFpg = $data[0];
		//$iDesFpg = $data[1];
		
		$iCodSdp = $data[0];
		
		/** CABECERAS **/
		error_reporting(E_ALL);
		ini_set('display_errors', TRUE);
		ini_set('display_startup_errors', TRUE);   

		ini_set("memory_limit", "-1");
		set_time_limit(0);		
		
		//NUEVO OBJETO GENERAL
		$objPHPExcel = new PHPExcel();

		//PROPIEDADES METADATOS
		$objPHPExcel->getProperties()->setCreator("Contacar")
					     ->setLastModifiedBy("Operador de Contacar")
					     ->setTitle("Office Exportacion")
					     ->setSubject("Office Exportacion")
					     ->setDescription("Office Exportacion")
					     ->setKeywords("office 2007 openxml php")
					     ->setCategory("Office Exportacion");                                      
				
		/*Centrar Celdas*/            
		$objPHPExcel->getActiveSheet()->getStyle('A1:F1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
		$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('A1', 'Codigo Empresa Origen')
			    ->setCellValue('B1', 'Codigo Banco Origen')
				->setCellValue('C1', 'Monto de Traspado $')
				->setCellValue('D1', 'Fecha de Traspaso (AAAAMMDD)')
				
				->setCellValue('E1', 'Codigo Empresa Destino')
			    ->setCellValue('F1', 'Codigo Banco Destino');


		/*Centrar Celdas*/            
		$objPHPExcel->getActiveSheet()->getStyle('H1:J1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
		$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('H1', 'Codigo Empresa')
			    ->setCellValue('I1', 'Empresa')
				->setCellValue('J1', 'Codigo Cuenta')
				->setCellValue('K1', 'Cuenta');

		$csu_scd_per = $this
                        ->mdl_exp_exc
                        ->mdl_csu_scd_per($iCodSdp,0,0,0,0,0,"","","");  
						
		$Ct = 1;		
		
		/*tamaño letra en grilla*/
		$objPHPExcel->getDefaultStyle()
			    ->getFont()                    
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(false)        
			    ->getColor();   
				
		foreach ($csu_scd_per as $scd)
		{
		
			$Ct = $Ct + 1;

			$objPHPExcel->setActiveSheetIndex(0)
			->setCellValue('H' . $Ct, $scd->tsp_cod_sdp)
			->setCellValue('I' . $Ct, $scd->tsp_rzn_scl);
			
			$csu_bco_sdp = $this->mdl_exp_exc->mdl_csu_bco_sdp(0,$scd->tsp_cod_sdp);
			
			foreach ($csu_bco_sdp as $bco)
			{
				$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('J' . $Ct, $bco->tbs_cod_bco)
				->setCellValue('K' . $Ct, $bco->tmb_des_bco.' - '.$bco->tbs_num_cta);
				$Ct = $Ct + 1;
			}
			$Ct = $Ct + 1;
			//$objPHPExcel->getActiveSheet()->getStyle('K' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		}
		   
	
				      
		$objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
		//Unir celdas 
		//$objPHPExcel->getActiveSheet()->mergeCells('B2:E2');
		//$objPHPExcel->getActiveSheet()->mergeCells('F2:K2');
		     
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);

		

			    
		$objPHPExcel->getActiveSheet()->setTitle('Traspado de Cuentas');
		$objPHPExcel->setActiveSheetIndex(0);         
		
		//header('Content-Type: application/vnd.ms-excel');
		header('Content-type: text/csv');
		header('Content-Disposition: attachment;filename="Formato_traspaso_cuentas.xls"');
		header('Cache-Control: max-age=0');
		header('Cache-Control: max-age=1');       
		
		header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
		header ('Cache-Control: cache, must-revalidate');
		header ('Pragma: public'); // HTTP/1.0

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');      

	}
	
	Public Function fnc_sub_det_tcr()
  { 
		$iCodCrd = $this->input->post('iCodCrd'); 
		$iFlgPry = $this->input->post('iFlgPry');
		$iLgnUsr = $this->input->post('iLgnUsr');
	
		$mensaje = '';
    //obtenemos el archivo .csv
    $name = $_FILES['brwCgaDetTcr']['name'];

    $chk_ext = explode(".",$name);
    
    if(strtolower(end($chk_ext)) == "csv")
    {
			
      $filename = $_FILES['brwCgaDetTcr']['tmp_name'];
      $handlev = fopen($filename, "r");
			$handlei = fopen($filename, "r");
            $v = 0;
			$i = 0;
			
			$iSdpOrg = 0;
			$iMtoTcr = 0;
			while (($data = fgetcsv($handlei, 1000, ";")) !== FALSE)
			{ 
				if($i != 0)
				{
						$iSdpOrg = $data[0];
						$iBcoOrg = $data[1];
						$iMtoTcr = $data[2];
						$iFecTcr = $data[3];
						$iSdpDtn = $data[4];
						$iBcoDtn = $data[5];						
			
						If($iSdpOrg > 0) {

							//Función generica para traer un campo en particular -----------------------------
							//Cuenta mercantil
							$iCtaMerDtn = Fnc_Csu_Cmp_Tab('tab_scd_per','tsp_cta_mer','tsp_cod_sdp',$iSdpOrg);
							$iCtaMerOrg = Fnc_Csu_Cmp_Tab('tab_scd_per','tsp_cta_mer','tsp_cod_sdp',$iSdpDtn);			
							//--------------------------------------------------------------------------------

							if($iSdpOrg === $iSdpDtn and $iBcoOrg === $iBcoDtn){
								$mensaje = 'Empresa de origen y destino con sus cuentas, no pueden ser iguales <br>';
							}
							if($iMtoTcr <= 0){
								$mensaje = $mensaje.'El monto debe ser mayor a 0 <br>';
							}
							if($iCtaMerDtn->tmp_cmp_gnr == ''){
								$mensaje = $mensaje.'No existe cuenta mercatil asociada para la sociedad: ' . $iSdpOrg . '<br>';
							}
							if($iCtaMerOrg->tmp_cmp_gnr == ''){
								$mensaje = $mensaje.'No existe cuenta mercatil asociada para la sociedad: ' . $iSdpDtn . '<br>';
							}

							if($mensaje <> ''){
								echo json_encode(
									array(
										'success'  => false,
										'data'     => "Fila ".$i."<br/> ".$mensaje                
									)
								);
								exit();
							}
						}
					
				}
				$i++;
			}	
					
			fclose($handlev);
			fclose($handlei);
		
			$filename = $_FILES['brwCgaDetTcr']['tmp_name'];
			$handlev = fopen($filename, "r");
			$handlei = fopen($filename, "r");
			$v = 0;
			$i = 0;		
			
			$iSdpOrg = 0;
				while (($data = fgetcsv($handlei, 1000, ";")) !== FALSE)
				{
					
					if($i != 0)
					{
						$iCodDet = "-1";
						$iSdpOrg = $data[0];
						$iBcoOrg = $data[1];
						$iMtoTcr = $data[2];
						$iFecTcr = $data[3];
						$iSdpDtn = $data[4];
						$iBcoDtn = $data[5];
						
						if($iSdpOrg > 0){
							$grb_det_tcr = $this->fnc_grb_cga_det_tcr($iCodDet,$iCodCrd,$iSdpOrg,$iBcoOrg,$iMtoTcr,$iFecTcr,'126',$iSdpDtn,$iBcoDtn,$iMtoTcr,$iFecTcr,'113','');
							
							//
							
							$des_sdp_org = '';
							$des_bco_org = '';
							$des_sdp_dtn = '';
							$des_bco_dtn = '';
							
							foreach ($grb_det_tcr as $det)
							{
									$iCodDet = $det->cod_idd;	
									$des_sdp_org = $det->des_sdp_org;
									$des_bco_org = $det->des_bco_org;
									$des_sdp_dtn = $det->des_sdp_dtn;
									$des_bco_dtn = $det->des_bco_dtn;
							}

							if($iCodDet > 0){	
	                                             
								$iFecMvt = $iFecTcr;
								$iAnoMes = $iFecTcr;
								$iAnoMvt = $iFecTcr;
								$iFecCmb = $iFecTcr;
								$iObsOrg = "Traspaso de fondos desde: " . $des_sdp_org . " cuenta: " . $des_bco_org . " a " . $des_sdp_dtn . " cuenta: " . $des_bco_dtn;
							
								//Función generica para traer un campo en particular -----------------------------
								//Cuenta mercantil
								$iCtaMerDtn = Fnc_Csu_Cmp_Tab('tab_scd_per','tsp_cta_mer','tsp_cod_sdp',$iSdpOrg);
								$iCtaMerOrg = Fnc_Csu_Cmp_Tab('tab_scd_per','tsp_cta_mer','tsp_cod_sdp',$iSdpDtn);
								//Codigo del proveedor
								$iCodPrvDtn = Fnc_Csu_Cmp_Tab('tab_scd_per','tmp_cod_prv','tsp_cod_sdp',$iSdpOrg);
								$iCodPrvOrg = Fnc_Csu_Cmp_Tab('tab_scd_per','tmp_cod_prv','tsp_cod_sdp',$iSdpDtn);
								//--------------------------------------------------------------------------------

								$this->mdl_det_pry->fnc_grb_det_pry("-1",$iSdpOrg,$iBcoOrg,$iCodPrvOrg->tmp_cmp_gnr,"PRV",$iLgnUsr,"1","FRM_TSP_CRL_MSV",$iCodCrd,$iCodDet,$iMtoTcr,$iMtoTcr,"55","126",$iFecMvt,$iAnoMes,$iAnoMvt,$iFlgPry,$iFecCmb,$iObsOrg,$iCtaMerOrg->tmp_cmp_gnr,0); 

								$this->mdl_det_pry->fnc_grb_det_pry("-1",$iSdpDtn,$iBcoDtn,$iCodPrvDtn->tmp_cmp_gnr,"CLI",$iLgnUsr,"1","FRM_TSP_CRL_MSV",$iCodCrd,$iCodDet,$iMtoTcr,$iMtoTcr,"55","113",$iFecMvt,$iAnoMes,$iAnoMvt,$iFlgPry,$iFecCmb,$iObsOrg,$iCtaMerDtn->tmp_cmp_gnr,0);
							}							
						}
					}

					$i++;
					
				}

					fclose($handlev);
					fclose($handlei);

					$mensaje = "La carga de data ha finalizado exitosamente";

					echo json_encode(
						array(
							'success'  => true,
							'data'     => $mensaje                     
						)
					);
			
        }
        else
        {
					$mensaje = "Formato de archivo incorrecto!";

						echo json_encode(
							array(
								'success'  => false,
								'data'     => $mensaje                     
							)
						);
        }
	}
	
	
	Public Function fnc_grb_cga_det_tcr($iCodDet,$iCodCrd,$iSdpOrg,$iBcoOrg,$iMtoOrg,$iFecRtr,$iRflOrg,$iSdpDtn,$iBcoDtn,$iMtoDtn,$iFecIng,$iRflDtn,$iDetCar)
	{   			
		/*Se obtinene la fecha y hora para generar código interno*/
		$iKeyIdd = substr(Date('Ymdhis').microtime(),0,15);
		
		/*[AUT-20201219 : Parametros de Entrada desde ExtJS]*/
		

		/*[AUT-20201219 : Reemplazo de apóstrofe para parámetros de Entrada desde ExtJS]*/
		$iCodDet = str_replace("'", "´", $iCodDet);
		$iKeyIdd = str_replace("'", "´", $iKeyIdd);
		$iCodCrd = str_replace("'", "´", $iCodCrd);
		$iSdpOrg = str_replace("'", "´", $iSdpOrg);
		$iBcoOrg = str_replace("'", "´", $iBcoOrg);
		$iMtoOrg = str_replace("'", "´", $iMtoOrg);
		$iFecRtr = str_replace("'", "´", $iFecRtr);
		$iRflOrg = str_replace("'", "´", $iRflOrg);
		$iSdpDtn = str_replace("'", "´", $iSdpDtn);
		$iBcoDtn = str_replace("'", "´", $iBcoDtn);
		$iMtoDtn = str_replace("'", "´", $iMtoDtn);
		$iFecIng = str_replace("'", "´", $iFecIng);
		$iRflDtn = str_replace("'", "´", $iRflDtn);
		$iDetCar = str_replace("'", "´", $iDetCar);

		/*[AUT-20201219 : Formación de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim(strtoupper($iCodDet));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iKeyIdd)) . "'";
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodCrd));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iSdpOrg));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iBcoOrg));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iMtoOrg));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iFecRtr)) . "'";
		$iPrm = $iPrm . "   , " . trim(strtoupper($iRflOrg));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iSdpDtn));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iBcoDtn));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iMtoDtn));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iFecIng)) . "'";
		$iPrm = $iPrm . "   , " . trim(strtoupper($iRflDtn));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iDetCar)) . "'";

		/*[AUT-20201219 : Llamada al Servicio MySQL]*/	
		$sSql = "sva_grb_det_tcr";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
		$query = $this->db->query($sExe);

		$res=$query->result();
        
        $query->next_result(); 
        $query->free_result(); 

        return $res;
	}
}