<?php
include 'enableCORS.php';
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

use PhpOffice\PhpWord\TemplateProcessor;

class Cls_exp_wrd extends CI_Controller {
  
  function __construct() {
    enableCORS(); 
    parent::__construct();
    /* CARGAMOS LIBRERIAS PARA ESTE CONTROLLER*/       
    include(dirname(__FILE__).'/../libraries/PHPWord-master/src/PhpWord/Autoloader.php');
    \PhpOffice\PhpWord\Autoloader::register();
    
    $this->load->helper('fnc_gnr_helper');
    //$this->load->model(array('mdl_ctr_arr'));  
    $this->load->model('mdl_ctr_arr');  
       
  }   

  /*CONTRATO DE ARRIENDO*/   
  Public Function fnc_exp_wrd_ctr_arr()
  {   
    /*[AUT-20180227 : Parametros de Entrada desde ExtJS]*/        
    $data = json_decode($this->input->get('jObject'), true);   

    /*[AUT-20180227 : Parametros de Entrada desde ExtJS]*/
    $iNumCtr = $data[0];
   
    $contrato = $this->mdl_ctr_arr->mdl_csu_ctr_arr($iNumCtr,'','',0,0,0,0,0,'','','','',0,0,'','','','','','',0);

    /*Abrimos la plantilla*/       
    $templateCtrArr = new TemplateProcessor(dirname(__FILE__).'/../../contents/CONTRATO_DE_ARRIENDO.docx');    
      
    foreach ($contrato as $ctr)
    {     

        $iFecIni = explode('/', $ctr->tca_fec_ini); // Recibo Fecha
        $newFecIni = $iFecIni[2].''.$iFecIni[1].''.$iFecIni[0]; // Damos vuelta la fecha Ymd para poder usar funcion php strtotime
        
        $templateCtrArr->setValue('@@fec-hoy', strtolower(formato_fecha($ctr->fec_dia_imp,2)));          
        $templateCtrArr->setValue('@@nom-arr', $ctr->tma_nom_arr); 
        $templateCtrArr->setValue('@@nac-arr', strtolower($ctr->tma_nac_arr)); 
        $templateCtrArr->setValue('@@est-civ', strtolower($ctr->tec_des_civ)); 
        $templateCtrArr->setValue('@@rut-arr', strtolower(fnc_rut_con_pal($ctr->tma_rut_arr . '-' . $ctr->tma_dvf_arr)));
        $templateCtrArr->setValue('@@dir-prp', $ctr->tme_dir_edf . ' ' . strtolower(fnc_num_enn_pal($ctr->tme_dir_num))); 
        $templateCtrArr->setValue('@@num-dep', strtolower(fnc_num_enn_pal($ctr->tmp_num_dep))); 
        $templateCtrArr->setValue('@@com-edf', $ctr->tmc_com_edf); 
        $templateCtrArr->setValue('@@dur-ctr', strtolower(fnc_num_enn_pal($ctr->tca_dur_ctr))); 
        $templateCtrArr->setValue('@@val-arr', fnc_num_enn_pal($ctr->tca_val_arr)); 
        $templateCtrArr->setValue('@@mto-gar', fnc_num_enn_pal($ctr->tca_mto_gar)); 
        $templateCtrArr->setValue('@@arr-gar', fnc_num_enn_pal($ctr->tca_val_arr + $ctr->tca_mto_gar)); 
        $templateCtrArr->setValue('@@prm-rea', strtolower(formato_fecha(date("d-m-Y", strtotime(($ctr->tca_rjs_ctr + 1) . " month", strtotime($newFecIni))),3))); 
        $templateCtrArr->setValue('@@fec-ini', strtolower(formato_fecha($ctr->tca_fec_ini,2)));         
        $templateCtrArr->setValue('@@mes-rea', strtolower(formato_fecha($ctr->tca_fec_ini,4))); 
        
        /*Consultamos último reajuste*/
        $reajuste = $this->mdl_ctr_arr->mdl_csu_rjs_cua_pgo($iNumCtr);
        foreach ($reajuste as $UltRea) {
          $templateCtrArr->setValue('@@ult-rea', strtolower(formato_fecha(date("d-m-Y", strtotime("-2 month", strtotime($UltRea->tcp_per_ctr . '01'))),4)));          
        }            
       
        /*Busqueda de avales
        '----------------------------------------------------------------------------------------------------*/
        $sNomAvl = '';
        $iValCtr = $this->mdl_ctr_arr->mdl_csu_nub_ayc(0,$iNumCtr,0);
        
        if($iValCtr){

          foreach ($iValCtr as $val) {          
             
            if ($sNomAvl == ''){

              $sNomAvl = $val->tma_nom_avl;
              $sNacAvl = strtolower($val->tma_nac_avl);            
              $sEstAvl = strtolower($val->tma_est_civ);              
              $sRutAvlStr = strtolower(fnc_rut_con_pal(str_replace("", ".", $val->tmp_rut_avl)));                            
              $sRutAvlNum = $val->tmp_rut_avl;

            }else{

              $sNomAvl = $sNomAvl . ', ' . $val->tma_nom_avl;
              $sNacAvl = $sNacAvl . ', ' . strtolower($val->tma_nac_avl);
              $sEstAvl = $sEstAvl . ', ' . strtolower($val->tma_est_civ);
              $sRutAvlStr = $sRutAvlStr . ', ' . strtolower(fnc_rut_con_pal(str_replace(".", "", $val->tmp_rut_avl)));                            
              $sRutAvlNum = $sRutAvlNum . ', ' . $val->tmp_rut_avl;
            }

          } 

        }else{

              $sNomAvl = '';
              $sNacAvl = '';            
              $sEstAvl = '';
              $sRutAvlStr = '';
              $sRutAvlNum = '';
        }

        $templateCtrArr->setValue('@@nac-avl', $sNacAvl); 
        $templateCtrArr->setValue('@@est-avl', $sEstAvl); 
        $templateCtrArr->setValue('@@nom-avl', $sNomAvl); 
        $templateCtrArr->setValue('@@rut-avl-str', $sRutAvlStr); 

        /*'----------------------------------------------------------------------------------------------------*/              
    }
     
    $templateCtrArr->saveAs('CONTRATO_DE_ARRIENDO.docx');

    header("Content-Disposition: attachment; filename=CONTRATO_DE_ARRIENDO.docx; charset=iso-8859-1");
    echo file_get_contents('CONTRATO_DE_ARRIENDO.docx');

  }    

  /*CONTRATO DE RECOMENDACIONES*/
  Public Function fnc_exp_wrd_ctr_arr_rec()
  {   
    /*[AUT-20180303 : Parametros de Entrada desde ExtJS]*/        
    $data = json_decode($this->input->get('jObject'), true);   

    /*[AUT-20180303 : Parametros de Entrada desde ExtJS]*/
    $iNumCtr = $data[0];
   
    $contrato = $this->mdl_ctr_arr->mdl_csu_ctr_arr($iNumCtr,'','',0,0,0,0,0,'','','','',0,0,'','','','','','',0);

    /*Abrimos la plantilla*/       
    $templateCtrRec = new TemplateProcessor(dirname(__FILE__).'/../../contents/CONTRATO_DE_RECOMENDACIONES.docx');

    foreach ($contrato as $ctr)
    {                   
       $templateCtrRec->setValue('@@nom-arr', $ctr->tma_nom_arr);                
       $templateCtrRec->setValue('@@rut-arr', number_format((float)$ctr->tma_rut_arr, 0,'','.') . '-' . $ctr->tma_dvf_arr);         
    }       
    
    $templateCtrRec->saveAs('CONTRATO_DE_RECOMENDACIONES.docx');
    
    header("Content-Disposition: attachment; filename=CONTRATO_DE_RECOMENDACIONES.docx; charset=iso-8859-1");
    echo file_get_contents('CONTRATO_DE_RECOMENDACIONES.docx');

  }    

  /*CUIDADOS_GENERALES*/
  Public Function fnc_exp_wrd_cui_gnr()
  {   
    /*[AUT-20180303 : Parametros de Entrada desde ExtJS]*/        
    $data = json_decode($this->input->get('jObject'), true);   

    /*[AUT-20180303 : Parametros de Entrada desde ExtJS]*/
    $iNumCtr = $data[0];
   
    $contrato = $this->mdl_ctr_arr->mdl_csu_ctr_arr($iNumCtr,'','',0,0,0,0,0,'','','','',0,0,'','','','','','',0);

    /*Abrimos la plantilla*/       
    $templateCuiRec = new TemplateProcessor(dirname(__FILE__).'/../../contents/CUIDADOS_GENERALES.docx'); 

    foreach ($contrato as $ctr)
    {                   
        $templateCuiRec->setValue('@@nom-arr', $ctr->tma_nom_arr);         
        $templateCuiRec->setValue('@@rut-arr', number_format((float)$ctr->tma_rut_arr, 0,'','.') . '-' . $ctr->tma_dvf_arr);         
    }   
    
    $templateCuiRec->saveAs('CUIDADOS_GENERALES.docx');
    
    header("Content-Disposition: attachment; filename=CUIDADOS_GENERALES.docx; charset=iso-8859-1");
    echo file_get_contents('CUIDADOS_GENERALES.docx');

  }  

}