<?php 
include 'enableCORS.php';
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Cls_flj_dri extends CI_Controller {

	function __construct()
	{
		enableCORS(); 
		parent::__construct();		

	}
	
	Public Function fnc_csu_tot_syt()
	{
		$metodo = $this->config->item('metodo');
		$iParEnt = json_decode($this->input->$metodo('jObject'), true);  

		/*[AUT-20200420 : Parametros de Entrada desde ExtJS]*/		
		$iTipFlj = $iParEnt[0];	
        $iCodSdp = $iParEnt[1];			

		/*[AUT-20200420 : Reemplazo de apóstrofe para parámetros de Entrada desde ExtJS]*/
		$iTipFlj = str_replace("'", "´", $iTipFlj);		
		$iCodSdp = str_replace("'", "´", $iCodSdp);	

		/*[AUT-20200420 : Formación de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim($iTipFlj);
        $iPrm = $iPrm . "  , '" . trim(strtoupper($iCodSdp)) . "'";		

		/*[AUT-20200420 : Llamada al Servicio MySQL]*/	
		$sSql = "svc_csu_tot_syt";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
		
		$query = $this->db->query($sExe);

		$data = array();
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}

        echo json_encode(
                    array(
                      'success'   => true,                                            
                      'data'      => $data
                    )
        );  
	}	
	
	Public Function fnc_csu_flj_dri()
	{
		$metodo = $this->config->item('metodo');
		$iParEnt = json_decode($this->input->$metodo('jObject'), true);  

		/*[AUT-20170605 : Parametros de Entrada desde ExtJS]*/
		$iFecFlj = $iParEnt[0];				
		$iTipFlj = $iParEnt[1];
		$iCodSdp = $iParEnt[2];
		
		$fields   = array(
						array('name' => 'tmp_tip_cta'),
						array('name' => 'trf_cod_rfl'), 
						array('name' => 'trf_des_rfl'),

						array('name' => 'tmp_egr_ing'),

						array('name' => 'tmp_val_pry',
							  'type' => 'float'
						),
						array('name' => 'tmp_val_ral',
							  'type' => 'float'
						),
						array('name' => 'tmp_val_dif',
							  'type' => 'float'
					    )					
					);

		$columns  = array(

			            array(
							'dataIndex'    => 'tmp_tip_cta',		
							'text'         => 'TIPO CUENTA',
							'hidden'       =>  true,
							'width'        => 100,
							'align'        => 'center',
							'menuDisabled' => true
						),

						array(
							'xtype' => 'rownumberer',							
							'text'  => '',
							'width' =>  40,
				            'align' => 'center'				            
				        ),

						array(
								'text'         => 'Empresa <br> RUT',								
								//'width'        => 179,
								'menuDisabled' => true,								
								'locked'       => true,								
								'columns'      => array(													                										
		                								array(
		                									'dataIndex'    => 'trf_des_rfl',
	                										'text'         => 'Bancos <br> Ctas. Corrientes',      						
	                										'width'        => 179,
															'style'        => 'text-align: center',
															'locked'       => true,
															'menuDisabled' => true,															
															'hideable'     => false,
															'renderer'     => '',															
															'summaryRenderer' => ''							
		                								)
		                						)        								
            			),         						            			

						array(
								'dataIndex'    => 'tmp_val_pry',		
								'text'         => 'PROYECTADO',
								'width'        => 100,
								'align'        => 'right', 
								'style'        => 'text-align: center', 
								'summaryType'  => 'sum',
								'locked'       => true,								
								'menuDisabled' => true,
								'sortable'     => false,														
								'renderer'     => '',
								'summaryRenderer' => ''					            																	
						),
											
						array(
								'dataIndex'    => 'tmp_val_ral',		
								'text'         => 'REAL',
								'width'        => 100,
								'align'        => 'right',
								'style'        => 'text-align: center',
								'summaryType'  => 'sum',  
								'locked'       => true,								
								'menuDisabled' => true,
								'sortable'     => false,								
								'renderer'     => '',
								'summaryRenderer' => ''								
						),

						array(
								'dataIndex'    => 'tmp_val_dif',		
								'text'         => 'DIF',
								'width'        => 100,
								'align'        => 'right',
								'style'        => 'text-align: center',  
								'summaryType'  => 'sum',
								'locked'       => true,								
								'menuDisabled' => true,
								'sortable'     => false,
								'renderer'     => '',
								'summaryRenderer' => ''
						)								
		);			

		
		$iEmpHld = $this->mdl_exp_exc->mdl_csu_scd_flj($iTipFlj,$iCodSdp); 			

		$Count = 1;		
		
		foreach ($iEmpHld as $emp) {
							
			$iCtsBco = $this->mdl_exp_exc->mdl_csu_bco_sdp(0,$emp->tsp_cod_sdp);						

			if($iCtsBco){				

				foreach ($iCtsBco as $bco) {						
					
					$cuenta[]   = array(
										'dataIndex'       => 'tmp_mto_flj' . $Count,
										'text'            => $bco->tmb_des_bco . '<br>' . $bco->tbs_num_cta,
										'iCodSdp'         => $emp->tsp_cod_sdp,
										'iCodBco'         => $bco->tbs_cod_bco,
										'align'           => 'right',
										'width'           =>  150,
										'style'           => 'text-align: center',
										'summaryType'     => 'sum',										
										'menuDisabled'    => true,
										'sortable'        => false,
										'tdCls'           => 'grid-cursor',									    
										'renderer'        => '',
										'summaryRenderer' => ''									
								);						

					$fields[]   = array('name' => 'tmp_mto_flj' . $Count,
										'type' => 'float'
								);	

					$Count = $Count + 1;												

				}

				$columns[]  = array(
									'layout'       =>	array(
		                                                    'align' => 'stretch'		                                                    
		                                                ),
									'text'         => $emp->tsp_nom_fan . '<br>' . $emp->tsp_rut_sdp . '-' . $emp->tsp_dvf_sdp,								
									'align'        => 'center',
									'menuDisabled' => true,	
									'sortable'     => false,
									'tdCls'        => 'grid-cursor',											
									'columns'      => $cuenta        											        			
				);
				
				unset($cuenta);
				$cuenta = array();
			}				

		}			
	
		$flujo = $this->mdl_exp_exc->mdl_csu_flj_dri($iFecFlj,$iTipFlj,$iCodSdp);

		foreach ($flujo as $flu) {			
			$data[] = $flu;
		}	

		/*------------------------------------------------------
		{
		    "metaData": {
		        "fields": [
		            
		        ],
		        "columns": [

		        ]
		    },
		    "data": [
		       
		    ]
		}
		*/

		$metaData  = array(
						'fields'  => $fields,
						'columns' => $columns						
		);

		//---------------------------------------------------------	
		
        echo json_encode(
                    array(
                      'success'   => true,                      
                      'metaData'  => $metaData,
                      'data'      => $data
                    )
        );
    	
	}	

	Public Function fnc_csu_dia_frd()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);		
		
		/*[AUT-20210115 : Parametros de Entrada desde ExtJS]*/
		$iFecDfr = $data[0];

		/*[AUT-20210115 : Reemplazo de apóstrofe para parámetros de Entrada desde ExtJS]*/
		$iFecDfr = str_replace("'", "´", $iFecDfr);

		/*[AUT-20210115 : Formación de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     '" . trim($iFecDfr) . "'";

		/*[AUT-20210115 : Llamada al Servicio MySQL]*/	
		$sSql = "svc_csu_dia_frd";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}
		
        echo json_encode(
                    array(
                      'success'  => true,
                      'data'     => $data                     
                    )
        );  
	}

	Public Function fnc_csu_itz_flj_dri()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);		
		
		/*[AUT-20210405 : Parametros de Entrada desde ExtJS]*/
		$iFecFlj = $data[0];
		$iCodSdp = $data[1];

		$interfaz = $this->mdl_exp_exc->mdl_csu_itz_flj_dia($iFecFlj,$iCodSdp);                        
	
		$data = array();
		foreach ($interfaz as $row)
		{
			$data[] = $row;
		}
		
        echo json_encode(
                    array(
                      'success'  => true,
                      'data'     => $data                     
                    )
        );  
	}
}