<?php 
include 'enableCORS.php';
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Cls_gto_prp extends CI_Controller {

	Public function __construct(){
		enableCORS(); 
	parent::__construct();
	/* CARGAMOS LIBRERIAS PARA ESTE CONTROLLER*/       
	include(dirname(__FILE__)."/../libraries/PHPExcel/Classes/PHPExcel.php");      
	include(dirname(__FILE__)."/../libraries/MPDF54/mpdf.php");
	$this->load->model(array('mdl_exp_exc')); 
	$this->load->model(array('mdl_exp_pdf')); 

	}
	Public Function fnc_csu_gto_prp()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  
		
		ini_set("memory_limit", "-1");
		set_time_limit(0);	

		/*[AUT-20180114 : Parametros de Entrada desde ExtJS]*/
		$iPerCtr = $data[0];
		$iOpcRpt = $data[1];

		/*[AUT-20180114 : Reemplazo de ap�strofe para par�metros de Entrada desde ExtJS]*/
		$iPerCtr = str_replace("'", "�", $iPerCtr);
		$iOpcRpt = str_replace("'", "�", $iOpcRpt);

		/*[AUT-20180114 : Formaci�n de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim(strtoupper($iPerCtr));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iOpcRpt));

		/*[AUT-20180114 : Llamada al Servicio MySQL]*/	
		$sSql = "rpt_csu_gto_prp";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}
		
		echo json_encode(
			    array(
			      'success'  => true,
			      'data'     => $data                     
			    )
		);  
	}
	
	
	
	Public Function fnc_exp_exc_gto()
	{
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/        
		$data = json_decode($this->input->get('jObject'), true);  						
		
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/
		$iPerCtr = $data[0];
		$iOpcRpt = $data[1];
		
		/** CABECERAS **/
		error_reporting(E_ALL);
		ini_set('display_errors', TRUE);
		ini_set('display_startup_errors', TRUE);   

		ini_set("memory_limit", "-1");
		set_time_limit(0);		
		
		//NUEVO OBJETO GENERAL
		$objPHPExcel = new PHPExcel();
		

		//PROPIEDADES METADATOS
		$objPHPExcel->getProperties()->setCreator("Contacar")
					     ->setLastModifiedBy("Operador de Contacar")
					     ->setTitle("Office Exportacion")
					     ->setSubject("Office Exportacion")
					     ->setDescription("Office Exportacion")
					     ->setKeywords("office 2007 openxml php")
					     ->setCategory("Office Exportacion");                                      
		
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Reporte de Gastos Propietario');        
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B2')
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(15)
			    ->setBold(true)
			    ->getColor();        
		       
		/*Centrar Celdas*/            
		$objPHPExcel->getActiveSheet()->getStyle('B5:L5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
		$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('B5', 'N Liquidacion')
			    ->setCellValue('C5', 'Propietario')
			    ->setCellValue('D5', 'Periodo')
			    ->setCellValue('E5', 'Cuenta Contable')
			    ->setCellValue('F5', 'Monto Gasto')
			    ->setCellValue('G5', 'Comentario Gasto')
			    ->setCellValue('H5', 'Cuenta Auxiliar')
			    ->setCellValue('I5', 'Tipo Propiedad')
			    ->setCellValue('J5', 'Unidad de Negocio')
			    ->setCellValue('K5', 'N Dpto')
			    ->setCellValue('L5', 'Torre');
			    
		//Configuraci�n de tipos de letra                         
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B5:L5')
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(true)        
			    ->getColor()
			    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
			    
		//fondo a celda
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B5:L5')
			    ->getFill()
			    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
			    ->getStartColor()
			    ->setARGB('&H808080');         

		$csu_gto_prp = $this
                        ->mdl_exp_exc
                        ->mdl_csu_gto_prp($iPerCtr,$iOpcRpt);  

		$Ct = 5;		
		
		/*tama�o letra en grilla*/
		$objPHPExcel->getDefaultStyle()
			    ->getFont()                    
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(false)        
			    ->getColor();   
		   
		foreach ($csu_gto_prp as $gto)
		{
			$Ct = $Ct + 1;
			
			$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('B' . $Ct, $gto->tca_num_ctr)
					->setCellValue('C' . $Ct, $gto->tmp_nom_pro)
					->setCellValue('D' . $Ct, $gto->tcp_per_ctr)
					->setCellValue('E' . $Ct, $gto->tcc_des_cta)
					->setCellValue('F' . $Ct, $gto->tdp_mto_cgo)
					->setCellValue('G' . $Ct, $gto->tdp_cmt_cgo)
					->setCellValue('H' . $Ct, $gto->tdp_cta_aux)
					->setCellValue('I' . $Ct, $gto->ttp_des_tip)
					->setCellValue('J' . $Ct, $gto->tme_nom_edf)
					->setCellValue('K' . $Ct, $gto->tmp_num_dep)
					->setCellValue('L' . $Ct, $gto->tmp_trr_prp);

			/*Separador de miles*/
			$objPHPExcel->getActiveSheet()->getStyle('F' . $Ct)->getNumberFormat()->setFormatCode('$#,##0;[Red]-$#,##0'); 
			
			/*Centrar Celdas*/       
			$objPHPExcel->getActiveSheet()->getStyle('B' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objPHPExcel->getActiveSheet()->getStyle('D' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objPHPExcel->getActiveSheet()->getStyle('F' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$objPHPExcel->getActiveSheet()->getStyle('K' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objPHPExcel->getActiveSheet()->getStyle('L' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		}   
				      
		$objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
		//Unir celdas 
		$objPHPExcel->getActiveSheet()->mergeCells('B2:E2');
		     
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
			    
		$objPHPExcel->getActiveSheet()->setTitle('Exportacion');
		$objPHPExcel->setActiveSheetIndex(0);         
		
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="Listado_de_Reporte_Gastos_Propietario.xls"');
		header('Cache-Control: max-age=0');
		header('Cache-Control: max-age=1');       
		
		header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
		header ('Cache-Control: cache, must-revalidate');
		header ('Pragma: public'); // HTTP/1.0

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');
	}
	
	
	
	
	Public function fnc_csu_gto_pdf()
	{
	
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/        
		$data = json_decode($this->input->get('jObject'), true); 		
		
		ini_set("memory_limit", "-1");
		set_time_limit(0);	
		
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/
		$iPerCtr = $data[0];
		$iOpcRpt = $data[1];
	
		$csu_gto_prp = $this->mdl_exp_pdf->mdl_csu_gto_prp($iPerCtr,$iOpcRpt);
	
		$extmod_str    =implode("",file(dirname(__FILE__).'/../../contents/html-rpt-gto.htm'));
		$extmod_str_enc=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-gto-enc.htm'));
		$extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-gto-det.htm'));	
        $extmod_str_tot=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-gto-tot.htm'));	
		$extmod_str_fnl=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-gto-fnl.htm'));			
		
		$img_log_goo = '<img  src="'. APPPATH . '../../archivos/logo/logo.png" width="150" height="44" alt="Logo"/>';
		$extmod_str=str_replace('@@img-log-cli', $img_log_goo, $extmod_str);
		
		$cnt_tot_prp = 0;
		$tmp_cod_pro = 0;
	
		
		foreach ($csu_gto_prp as $row)
		{
			$extmod_str=str_replace('@@csu_fec_sys',     $row->csu_fec_sys, $extmod_str);
			$extmod_str=str_replace('@@csu_hor_sys',     $row->csu_hor_sys, $extmod_str);

			if ($tmp_cod_pro != $row->tmp_cod_pro) {
				$tmp_cod_pro = $row->tmp_cod_pro;
				
				$extmod_str_enc=str_replace('@@tmp_nom_pro', $row->tmp_nom_pro, $extmod_str_enc);
				$adj_dev_det = "";
				$tot_mto_cgo = 0;
				$adj_adm_tot = "";
				foreach ($csu_gto_prp as $det)
				{	
					if($tmp_cod_pro == $det->tmp_cod_pro){
						$extmod_str_det=str_replace('@@tca_num_ctr', $det->tca_num_ctr, $extmod_str_det);
						$extmod_str_det=str_replace('@@tcc_des_cta', $det->tcc_des_cta, $extmod_str_det);
						$extmod_str_det=str_replace('@@tdp_cmt_cgo', $det->tdp_cmt_cgo, $extmod_str_det);
						$extmod_str_det=str_replace('@@ttp_des_tip', $det->ttp_des_tip, $extmod_str_det);
						$extmod_str_det=str_replace('@@tme_nom_edf', $det->tme_nom_edf, $extmod_str_det);
						$extmod_str_det=str_replace('@@tmp_num_dep', $det->tmp_num_dep, $extmod_str_det);
						$extmod_str_det=str_replace('@@tdp_cta_aux', $det->tdp_cta_aux, $extmod_str_det);
						$extmod_str_det=str_replace('@@tmp_trr_prp', $det->tmp_trr_prp, $extmod_str_det);
						$extmod_str_det=str_replace('@@tmp_mto_cgo', $det->tmp_mto_cgo, $extmod_str_det);

						$adj_dev_det = $adj_dev_det . $extmod_str_det;
						
						$tot_mto_cgo = $tot_mto_cgo + $det->tdp_mto_cgo;
					}
					$extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-gto-det.htm'));
				}
				
				$fnl_mto_cgo = $fnl_mto_cgo + $tot_mto_cgo;
				
				$tot_mto_cgo = number_format($tot_mto_cgo,0);
				$tot_mto_cgo = str_replace(",", ".", $tot_mto_cgo);
				
				$extmod_str_tot=str_replace('@@tot_mto_cgo', '$ '.$tot_mto_cgo, $extmod_str_tot);
				$adj_adm_tot = $adj_adm_tot . $extmod_str_tot;
				$extmod_str_tot=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-gto-tot.htm'));
				
				$adj_dev_enc = $adj_dev_enc . $extmod_str_enc . $adj_dev_det . $adj_adm_tot;
				$extmod_str_enc=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-gto-enc.htm'));
			}		
		}
		
		$fnl_mto_cgo = number_format($fnl_mto_cgo,0);
		$fnl_mto_cgo = str_replace(",", ".", $fnl_mto_cgo);
		
		$extmod_str_fnl=str_replace('@@fnl_mto_cgo', '$ '.$fnl_mto_cgo, $extmod_str_fnl);
		
		$extmod_str=str_replace('@@html-rpt-gto-enc', $adj_dev_enc . $extmod_str_fnl, $extmod_str);
		
		//configuramos PDF
		$mpdf= new mPDF(
			'',    // mode - default ''
			'A4-L',    // format - A4, for example, default ''
			0,     // font size - default 0
			'',    // default font family
			15,    // margin_left
			15,    // margin right
			16,    // margin top
			16,    // margin bottom
			9,     // margin header
			9,     // margin footer
			'L'    // L - landscape, P - portrait
			);			
		
		$mpdf->SetHTMLFooter('<hr align="center"; width="100% "; noshade; color=#9F9F9F><table width="100%" style="vertical-align: bottom; font-family: tahoma,geneva,sans-serif; font-size: 8pt; color: #9F9F9F; "><tr> <td width="50%" style="text-align: left;">Informe Mensual de Gstos de Propietario</td> <td width="50%" align="right";>{PAGENO}/{nbpg}</td> </tr></table>');
		//$mpdf->SetHTMLFooter('<hr align="center"; width="100% "; noshade; color=#9F9F9F><table width="100%" style="vertical-align: bottom; font-family: tahoma,geneva,sans-serif; font-size: 8pt; color: #9F9F9F; "><tr> <td width="33%"><span>{DATE j-m-Y}</span></td> <td width="30%" align="center" >{PAGENO}/{nbpg}</td> <td width="37%" style="text-align: left; ">Banco de Chile - Departamento de Mantencion</td> </tr></table>');
		//$mpdf->setFooter("Banco de Chile - Departamento de Mantencion", 'E');
		$mpdf->WriteHTML($extmod_str);
		$mpdf->Output("Reporte_Gastos_Propietario.pdf", "I");
	}

}