<?php 

include 'enableCORS.php';
if ( ! defined('BASEPATH')) exit('No direct script access allowed');


class Cls_mae_arr extends CI_Controller {

	Public function __construct(){
		enableCORS();
		parent::__construct();
		/* CARGAMOS LIBRERIAS PARA ESTE CONTROLLER*/       
		include(dirname(__FILE__)."/../libraries/PHPExcel/Classes/PHPExcel.php");      
		include(dirname(__FILE__)."/../libraries/MPDF54/mpdf.php");
		$this->load->model(array('mdl_exp_exc')); 
		$this->load->model(array('mdl_exp_pdf'));

	}
	
	Public Function fnc_grb_mae_arr()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  
				
		/*Se obtinene la fecha y hora para generar c�digo interno*/
		$iKeyIdd = substr(Date('Ymdhis').microtime(),0,15);
		
		/*[AUT-20180126 : Parametros de Entrada desde ExtJS]*/
		$iCodArr = $data[0];
		$iCodEst = $data[1];
		$iFecCre = $data[2];
		$iCodTip = $data[3];
		$iNomArr = $data[4];
		$iNacArr = $data[5];
		$iRutArr = $data[6];
		$iDvfArr = $data[7];
		$iCodCiv = $data[8];
		$iFecNac = $data[9];
		$iNomRpr = $data[10];
		$iRutRpr = $data[11];
		$iDvfRpr = $data[12];
		$iPrfCmr = $data[13];
		$iEmpCmr = $data[14];
		$iRutEmp = $data[15];
		$iDvfEmp = $data[16];
		$iCgoCmr = $data[17];
		$iWebEmp = $data[18];
		$iIngCmr = $data[19];
		$iAtgCmr = $data[20];
		$iEmlCmr = $data[21];
		$iTelCmr = $data[22];
		$iCelCmr = $data[23];
		$iFaxCmr = $data[24];
		$iDirCmr = $data[25];
		$iComCmr = $data[26];
		$iCiuCmr = $data[27];
		$iPosCmr = $data[28];
		$iNtaArr = $data[29];
		$iCodPfs = $data[30];

		/*[AUT-20180126 : Reemplazo de ap�strofe para par�metros de Entrada desde ExtJS]*/
		$iCodArr = str_replace("'", "�", $iCodArr);
		$iKeyIdd = str_replace("'", "�", $iKeyIdd);
		$iCodEst = str_replace("'", "�", $iCodEst);
		$iFecCre = str_replace("'", "�", $iFecCre);
		$iCodTip = str_replace("'", "�", $iCodTip);
		$iNomArr = str_replace("'", "�", $iNomArr);
		$iNacArr = str_replace("'", "�", $iNacArr);
		$iRutArr = str_replace("'", "�", $iRutArr);
		$iDvfArr = str_replace("'", "�", $iDvfArr);
		$iCodCiv = str_replace("'", "�", $iCodCiv);
		$iFecNac = str_replace("'", "�", $iFecNac);
		$iNomRpr = str_replace("'", "�", $iNomRpr);
		$iRutRpr = str_replace("'", "�", $iRutRpr);
		$iDvfRpr = str_replace("'", "�", $iDvfRpr);
		$iPrfCmr = str_replace("'", "�", $iPrfCmr);
		$iEmpCmr = str_replace("'", "�", $iEmpCmr);
		$iRutEmp = str_replace("'", "�", $iRutEmp);
		$iDvfEmp = str_replace("'", "�", $iDvfEmp);
		$iCgoCmr = str_replace("'", "�", $iCgoCmr);
		$iWebEmp = str_replace("'", "�", $iWebEmp);
		$iIngCmr = str_replace("'", "�", $iIngCmr);
		$iAtgCmr = str_replace("'", "�", $iAtgCmr);
		$iEmlCmr = str_replace("'", "�", $iEmlCmr);
		$iTelCmr = str_replace("'", "�", $iTelCmr);
		$iCelCmr = str_replace("'", "�", $iCelCmr);
		$iFaxCmr = str_replace("'", "�", $iFaxCmr);
		$iDirCmr = str_replace("'", "�", $iDirCmr);
		$iComCmr = str_replace("'", "�", $iComCmr);
		$iCiuCmr = str_replace("'", "�", $iCiuCmr);
		$iPosCmr = str_replace("'", "�", $iPosCmr);
		$iNtaArr = str_replace("'", "�", $iNtaArr);
		$iCodPfs = str_replace("'", "�", $iCodPfs);

		/*[AUT-20180126 : Formaci�n de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim(strtoupper($iCodArr));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iKeyIdd)) . "'";
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodEst));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iFecCre)) . "'";
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodTip));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iNomArr)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iNacArr)) . "'";
		$iPrm = $iPrm . "   , " . trim(strtoupper($iRutArr));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iDvfArr)) . "'";
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodCiv));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iFecNac)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iNomRpr)) . "'";
		$iPrm = $iPrm . "   , " . trim(strtoupper($iRutRpr));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iDvfRpr)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iPrfCmr)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iEmpCmr)) . "'";
		$iPrm = $iPrm . "   , " . trim(strtoupper($iRutEmp));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iDvfEmp)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iCgoCmr)) . "'";
		$iPrm = $iPrm . "   ,'" . trim($iWebEmp) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iIngCmr)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iAtgCmr)) . "'";
		$iPrm = $iPrm . "   ,'" . trim($iEmlCmr) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iTelCmr)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iCelCmr)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iFaxCmr)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iDirCmr)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iComCmr)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iCiuCmr)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iPosCmr)) . "'";
		$iPrm = $iPrm . "   ,'" . trim($iNtaArr) . "'";
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodPfs));

		/*[AUT-20180126 : Llamada al Servicio MySQL]*/	
		$sSql = "sva_grb_mae_arr";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}
		
		echo json_encode(
			    array(
			      'success'  => true,
			      'data'     => $data                     
			    )
		);  
	}
	
	Public Function fnc_csu_mae_arr()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  

		/*[AUT-20180114 : Parametros de Entrada desde ExtJS]*/
		$iCodArr = $data[0];
		$iCodEst = $data[1];
		$iCodTip = $data[2];
		$iNomArr = $data[3];
		$iRutArr = $data[4];
		$iCodCiv = $data[5];
		$iNomEdf = $data[6];
		$iCodUsu = $data[7];

		if($iCodUsu == null){
			$iCodUsu =	0;
		}

		/*[AUT-20180114 : Reemplazo de ap�strofe para par�metros de Entrada desde ExtJS]*/
		$iCodArr = str_replace("'", "�", $iCodArr);
		$iCodEst = str_replace("'", "�", $iCodEst);
		$iCodTip = str_replace("'", "�", $iCodTip);
		$iNomArr = str_replace("'", "�", $iNomArr);
		$iRutArr = str_replace("'", "�", $iRutArr);
		$iCodCiv = str_replace("'", "�", $iCodCiv);
		$iNomEdf = str_replace("'", "�", $iNomEdf);
		$iCodUsu = str_replace("'", "�", $iCodUsu);

		/*[AUT-20180114 : Formaci�n de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim(strtoupper($iCodUsu));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodArr));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodEst));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodTip));
		$iPrm = $iPrm . "   ,'%" . trim(strtoupper($iNomArr)) . "%'";
		$iPrm = $iPrm . "   , " . trim(strtoupper($iRutArr));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodCiv));
		$iPrm = $iPrm . "   ,'%" . trim(strtoupper($iNomEdf)) . "%'";

		/*[AUT-20180114 : Llamada al Servicio MySQL]*/	
		$sSql = "svc_csu_mae_arr";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}
		
		echo json_encode(
			    array(
			      'success'  => true,
			      'data'     => $data                     
			    )
		);  
	}
	
	Public Function fnc_exp_exc_arr()
	{        
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/        
		$data = json_decode($this->input->get('jObject'), true);  						
		
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/
		$iCodArr = $data[0];
		$iCodEst = $data[1];
		$iCodTip = $data[2];
		$iNomArr = $data[3];
		$iRutArr = $data[4];
		$iCodCiv = $data[5];
		$iNomEdf = $data[6];
		$iCodUsu = $data[7];

		if($iCodUsu ==null){
			$iCodUsu =0;
		}
		
		/** CABECERAS **/
		error_reporting(E_ALL);
		ini_set('display_errors', TRUE);
		ini_set('display_startup_errors', TRUE);   

		ini_set("memory_limit", "-1");
		set_time_limit(0);		
		
		//NUEVO OBJETO GENERAL
		$objPHPExcel = new PHPExcel();

		//PROPIEDADES METADATOS
		$objPHPExcel->getProperties()->setCreator("Contacar")
					     ->setLastModifiedBy("Operador de Contacar")
					     ->setTitle("Office Exportacion")
					     ->setSubject("Office Exportacion")
					     ->setDescription("Office Exportacion")
					     ->setKeywords("office 2007 openxml php")
					     ->setCategory("Office Exportacion");                                      
		
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Arrendatarios');        
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B2')
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(15)
			    ->setBold(true)
			    ->getColor();        
		       
		/*Centrar Celdas*/            
		$objPHPExcel->getActiveSheet()->getStyle('B5:J5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
		$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('B5', 'COD ID')
			    ->setCellValue('C5', 'RUT')
			    ->setCellValue('D5', 'Nombre / Rzn. Soc.')
			    ->setCellValue('E5', 'Tipo de Arriendo')
			    ->setCellValue('F5', 'Nacionalidad')
			    ->setCellValue('G5', 'Estado Civil')
			    ->setCellValue('H5', 'Profesion')
			    ->setCellValue('I5', 'Unidad de Negocio')
			    ->setCellValue('J5', 'Departamento');
			    
		//Configuraci�n de tipos de letra                         
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B5:J5')
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(true)        
			    ->getColor()
			    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
			    
		//fondo a celda
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B5:J5')
			    ->getFill()
			    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
			    ->getStartColor()
			    ->setARGB('&H808080');         

		$csu_mae_arr = $this
                        ->mdl_exp_exc
                        ->mdl_csu_mae_arr($iCodUsu,$iCodArr,$iCodEst,$iCodTip,$iNomArr,$iRutArr,$iCodCiv,$iNomEdf);  

		$Ct = 5;		
		
		/*tama�o letra en grilla*/
		$objPHPExcel->getDefaultStyle()
			    ->getFont()                    
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(false)        
			    ->getColor();   
		   
		foreach ($csu_mae_arr as $arr)
		{

			$Ct = $Ct + 1;

			$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('B' . $Ct, $arr->tma_cod_arr)
					->setCellValue('C' . $Ct, $arr->tmp_rut_arr)
					->setCellValue('D' . $Ct, $arr->tma_nom_arr)
					->setCellValue('E' . $Ct, $arr->tta_des_tip)
					->setCellValue('F' . $Ct, $arr->tma_nac_arr)
					->setCellValue('G' . $Ct, $arr->tec_des_civ)
					->setCellValue('H' . $Ct, $arr->tmp_des_pfs)
					->setCellValue('I' . $Ct, $arr->tme_nom_edf)
					->setCellValue('J' . $Ct, '');
			

			/*Centrar Celdas*/        
			//$objPHPExcel->getActiveSheet()->getStyle('B' . $Ct . ':F' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);  

			$objPHPExcel->getActiveSheet()->getStyle('B' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objPHPExcel->getActiveSheet()->getStyle('C' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		}   
				      
		$objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
		//Unir celdas 
		$objPHPExcel->getActiveSheet()->mergeCells('B2:E2');
		     
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
			    
		$objPHPExcel->getActiveSheet()->setTitle('Exportacion');
		$objPHPExcel->setActiveSheetIndex(0);         
		
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="Listado_de_Arrendatarios.xls"');
		header('Cache-Control: max-age=0');
		header('Cache-Control: max-age=1');       
		
		header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
		header ('Cache-Control: cache, must-revalidate');
		header ('Pragma: public'); // HTTP/1.0

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');      
	}
	
	
	Public Function fnc_eli_mae_arr()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  

		/*[AUT-20180111 : Parametros de Entrada desde ExtJS]*/
		$iCodArr = $data[0];

		/*[AUT-20180111 : Reemplazo de ap�strofe para par�metros de Entrada desde ExtJS]*/
		$iCodArr = str_replace("'", "�", $iCodArr);

		/*[AUT-20180111 : Formaci�n de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim(strtoupper($iCodArr));

		/*[AUT-20180111 : Llamada al Servicio MySQL]*/	
		$sSql = "sve_eli_mae_arr";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}
		
		echo json_encode(
			    array(
			      'success'  => true,
			      'data'     => $data                     
			    )
		);  
	}
	
	
	Public Function fnc_csu_crt_deu()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  

		/*[AUT-20180111 : Parametros de Entrada desde ExtJS]*/
		$iPerRjs = $data[0];
		$iNumCtr = $data[1];

		/*[AUT-20180111 : Reemplazo de ap�strofe para par�metros de Entrada desde ExtJS]*/
		$iCodArr = str_replace("'", "�", $iPerRjs);
		$iNumCtr = str_replace("'", "�", $iNumCtr);

		/*[AUT-20180111 : Formaci�n de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim(strtoupper($iPerRjs));
		$iPrm = $iPrm . "  ,  " . trim(strtoupper($iNumCtr));

		/*[AUT-20180111 : Llamada al Servicio MySQL]*/	
		$sSql = "svc_csu_crt_deu";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}
		
		echo json_encode(
			    array(
			      'success'  => true,
			      'data'     => $data                     
			    )
		);  
	}
	
	
	
	
	
	Public Function fnc_csu_deu_arr_pdf()
	{
	
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/        
		$data = json_decode($this->input->get('jObject'), true); 		

		ini_set("memory_limit", "-1");
		set_time_limit(0);	
		
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/
		$iFecIni = $data[0];
		$iFecFin = $data[1];

		$fec_ini=date_create($iFecIni);
		$fec_fin=date_create($iFecFin);
		$fec_ini = date_format($fec_ini,"d/m/Y");
		$fec_fin = date_format($fec_fin,"d/m/Y");
		
		$per_ctr =date_create($iFecIni);
		$iPerCtr = date_format($per_ctr,"Ym");
		
		$csu_chq_per = $this->mdl_exp_pdf->mdl_csu_deu_arr($iPerCtr);

		$extmod_str    =implode("",file(dirname(__FILE__).'/../../contents/html-rpt-deu-arr.htm'));
		$extmod_str_enc=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-deu-arr-enc.htm'));	
		$extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-deu-arr-det.htm'));	
		$extmod_str_tot=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-deu-arr-tot.htm'));
		$extmod_str_fnl=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-deu-arr-fnl.htm'));
		
		$img_log_goo = '<img  src="'. APPPATH . '../../archivos/logo/logo.png" width="150" height="44" alt="Logo"/>';
		$extmod_str=str_replace('@@img-log-cli', $img_log_goo, $extmod_str);
		$extmod_str=str_replace('@@per_ctr', $iPerCtr, $extmod_str);
		
		$cnt_tot_pro = 0;
		$tmp_des_tip = '';
		foreach ($csu_chq_per as $row)
		{
			$extmod_str=str_replace('@@csu_fec_sys',     $row->csu_fec_sys, $extmod_str);
			$extmod_str=str_replace('@@csu_hor_sys',     $row->csu_hor_sys, $extmod_str);

			if ($tmp_des_tip != $row->rpt_des_tip) {
				$tmp_des_tip = $row->rpt_des_tip;
				
				$extmod_str_enc=str_replace('@@rpt_des_tip', $row->rpt_des_tip, $extmod_str_enc);
				$cnt_tot_pro = 0;
				$adj_dev_det = "";
				$adj_adm_tot = 0;
				$tot_sld_pnd = 0;
				foreach ($csu_chq_per as $det)
				{	
					if($tmp_des_tip == $det->rpt_des_tip){
						$extmod_str_det=str_replace('@@rpt_num_ctr', $det->rpt_num_ctr, $extmod_str_det);
						$extmod_str_det=str_replace('@@rpt_nom_arr', $det->rpt_nom_arr, $extmod_str_det);
						$extmod_str_det=str_replace('@@rpt_nom_edf', $det->rpt_nom_edf, $extmod_str_det);
						$extmod_str_det=str_replace('@@rpt_des_tip', $det->rpt_des_tip, $extmod_str_det);
						$extmod_str_det=str_replace('@@rpt_num_dep', $det->rpt_num_dep, $extmod_str_det);
						$extmod_str_det=str_replace('@@rpt_trr_prp', $det->rpt_trr_prp, $extmod_str_det);
						
						$rpt_sld_pnd = $det->rpt_sld_pnd;
						$rpt_sld_pnd = number_format($rpt_sld_pnd,0);
						$rpt_sld_pnd = str_replace(",", ".", $rpt_sld_pnd);
		
						$extmod_str_det=str_replace('@@rpt_sld_pnd', '$ '.$rpt_sld_pnd, $extmod_str_det);
						
						$adj_dev_det = $adj_dev_det . $extmod_str_det;
						
						$cnt_tot_pro = $cnt_tot_pro + 1;
						
						$tot_sld_pnd = $tot_sld_pnd + $det->rpt_sld_pnd;
					}
					$extmod_str_det=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-deu-arr-det.htm'));
				}
				
				$fnl_sld_pnd = $fnl_sld_pnd + $tot_sld_pnd;
				
				$tot_sld_pnd = number_format($tot_sld_pnd,0);
				$tot_sld_pnd = str_replace(",", ".", $tot_sld_pnd);
				$extmod_str_tot=str_replace('@@tot_sld_pnd', '$ '.$tot_sld_pnd, $extmod_str_tot);
				
				$adj_adm_tot = $adj_adm_tot . $extmod_str_tot;
				$extmod_str_tot=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-deu-arr-tot.htm'));
				
				$extmod_str_enc=str_replace('@@cnt_tot_pro', $cnt_tot_pro, $extmod_str_enc);
				
				$adj_dev_enc = $adj_dev_enc . $extmod_str_enc . $adj_dev_det . $adj_adm_tot;
				$extmod_str_enc=implode("",file(dirname(__FILE__).'/../../contents/html-rpt-deu-arr-enc.htm'));
			}		
		}
		
			
		if($cnt_tot_pro == 0){
			$extmod_str=str_replace('@@csu_fec_sys',     '', $extmod_str);
			$extmod_str=str_replace('@@csu_hor_sys',     '', $extmod_str);
			$extmod_str=str_replace('@@var_glb_reg',     'No se encontraron datos a imprimir', $extmod_str);
		}
		else{
			$extmod_str=str_replace('@@var_glb_reg',     '', $extmod_str);
		}
		
		$fnl_sld_pnd = number_format($fnl_sld_pnd,0);
		$fnl_sld_pnd = str_replace(",", ".", $fnl_sld_pnd);
		$extmod_str_fnl=str_replace('@@fnl_sld_pnd', '$ '.$fnl_sld_pnd, $extmod_str_fnl);
		
		$extmod_str=str_replace('@@html-rpt-deu-arr-enc', $adj_dev_enc.$extmod_str_fnl, $extmod_str);
		
		
		//configuramos PDF
		$mpdf= new mPDF(
			'',    // mode - default ''
			'A4-L',    // format - A4, for example, default ''
			0,     // font size - default 0
			'',    // default font family
			15,    // margin_left
			15,    // margin right
			16,    // margin top
			16,    // margin bottom
			9,     // margin header
			9,     // margin footer
			'L'    // L - landscape, P - portrait
			);			
		
		$mpdf->SetHTMLFooter('<hr align="center"; width="100% "; noshade; color=#9F9F9F><table width="100%" style="vertical-align: bottom; font-family: tahoma,geneva,sans-serif; font-size: 8pt; color: #9F9F9F; "><tr> <td width="50%" style="text-align: left;">Listado de Arrendatarios con Deuda</td> <td width="50%" align="right";>{PAGENO}/{nbpg}</td> </tr></table>');
		//$mpdf->SetHTMLFooter('<hr align="center"; width="100% "; noshade; color=#9F9F9F><table width="100%" style="vertical-align: bottom; font-family: tahoma,geneva,sans-serif; font-size: 8pt; color: #9F9F9F; "><tr> <td width="33%"><span>{DATE j-m-Y}</span></td> <td width="30%" align="center" >{PAGENO}/{nbpg}</td> <td width="37%" style="text-align: left; ">Banco de Chile - Departamento de Mantencion</td> </tr></table>');
		//$mpdf->setFooter("Banco de Chile - Departamento de Mantencion", 'E');
		$mpdf->WriteHTML($extmod_str);
		$mpdf->Output("Listado_de_Arrendatarios_con_Deuda.pdf", "I");
	}
}