<?php 
include 'enableCORS.php';
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Cls_rpt_pgg extends CI_Controller {
	Public function __construct(){
		enableCORS(); 
		parent::__construct();/* CARGAMOS LIBRERIAS PARA ESTE CONTROLLER*/       

		include(dirname(__FILE__)."/../libraries/PHPExcel/Classes/PHPExcel.php");      
		include(dirname(__FILE__)."/../libraries/MPDF54/mpdf.php");
		$this->load->model(array('mdl_rpt_pgg')); 
	}

	Public Function fnc_csu_pgg()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  
		
		ini_set("memory_limit", "-1");
		set_time_limit(0);

		/*[AUT-20180110 : Parametros de Entrada desde ExtJS]*/
		$iCodPrp = $data[0];
		$iTipPrp = $data[1];
		$iCodPro = $data[2];
		$iCodEst = $data[3];
		$iCodUsu = $data[4];
		
		$sStart = isset($_POST['start'])?$_POST['start']:0; //posición a iniciar
        $sLimit = isset($_POST['limit'])?$_POST['limit']:50; //número de registros a mostrar 
		
		/*[AUT-20180110 : Reemplazo de apóstrofe para parámetros de Entrada desde ExtJS]*/
		$iCodPrp = str_replace("'", "´", $iCodPrp);
		$iTipPrp = str_replace("'", "´", $iTipPrp);
		$iCodPro = str_replace("'", "´", $iCodPro);
		$iCodEst = str_replace("'", "´", $iCodEst);
		$iCodUsu = str_replace("'", "´", $iCodUsu);

		/*[AUT-20180110 : Formación de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim(strtoupper($iCodPrp));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iTipPrp));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodPro));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodEst));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodUsu));
		
		$iPrm = $iPrm . "   , " . trim($sStart);
        $iPrm = $iPrm . "   , " . trim($sLimit);
		
		
		/*[AUT-20180110 : Llamada al Servicio MySQL]*/	
		$sSql = "svc_csu_btc_pgg";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		$totalCount = 0;
		foreach ($query->result() as $row)
		{ 
			$data[] = $row;

			$totalCount = $row->totalCount;
		}

		echo json_encode(
			    array(
			      'success'  => true,
				  'total'   => $totalCount,
			      'data'     => $data                     
			    )
		);  
	}

	Public Function fnc_csu_pgg_con()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  
		
		ini_set("memory_limit", "-1");
		set_time_limit(0);

		/*[AUT-20180110 : Parametros de Entrada desde ExtJS]*/
		$iCodPrp = $data[0];
		
		/*[AUT-20180110 : Reemplazo de apóstrofe para parámetros de Entrada desde ExtJS]*/
		$iCodPrp = str_replace("'", "´", $iCodPrp);

		/*[AUT-20180110 : Formación de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim(strtoupper($iCodPrp));
		
		/*[AUT-20180110 : Llamada al Servicio MySQL]*/	
		$sSql = "svc_csu_btc_pgg_con";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		$totalCount = 0;
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}

		echo json_encode(
			    array(
			      'success'  => true,
			      'data'     => $data                     
			    )
		);  
	}

	Public Function fnc_csu_pgg_doc()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  
		
		ini_set("memory_limit", "-1");
		set_time_limit(0);

		/*[AUT-20180110 : Parametros de Entrada desde ExtJS]*/
		$iNumCtr = $data[0];
		
		/*[AUT-20180110 : Reemplazo de apóstrofe para parámetros de Entrada desde ExtJS]*/
		$iNumCtr = str_replace("'", "´", $iNumCtr);

		/*[AUT-20180110 : Formación de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim(strtoupper($iNumCtr));
		
		/*[AUT-20180110 : Llamada al Servicio MySQL]*/	
		$sSql = "svc_csu_btc_pgg_doc";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		$totalCount = 0;
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}

		echo json_encode(
			    array(
			      'success'  => true,
			      'data'     => $data                     
			    )
		);  
	}

	Public Function fnc_exp_csu_pgg()
	{        
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/        
		$data = json_decode($this->input->get('jObject'), true);  						
		
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/
		$iCodPrp = $data[0];
		$iTipPrp = $data[1];
		$iCodPro = $data[2];
		$iCodEst = $data[3];
		$iCodUsu = $data[4];
		
		/** CABECERAS **/
		error_reporting(E_ALL);
		ini_set('display_errors', TRUE);
		ini_set('display_startup_errors', TRUE);   

		ini_set("memory_limit", "-1");
		set_time_limit(0);		
		
		//NUEVO OBJETO GENERAL
		$objPHPExcel = new PHPExcel();

		//PROPIEDADES METADATOS
		$objPHPExcel->getProperties()->setCreator("Contacar")
					     ->setLastModifiedBy("Operador de Contacar")
					     ->setTitle("Office Exportacion")
					     ->setSubject("Office Exportacion")
					     ->setDescription("Office Exportacion")
					     ->setKeywords("office 2007 openxml php")
					     ->setCategory("Office Exportacion");                                      
		
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Propiedades GG');        
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B2')
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(15)
			    ->setBold(true)
			    ->getColor();        
		       
		/*Centrar Celdas*/            
		$objPHPExcel->getActiveSheet()->getStyle('B5:H5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
		$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('B5', 'Codigo Propiedad')
				->setCellValue('C5', 'ROL')
				->setCellValue('D5', 'Tipo Propiedad')
			    ->setCellValue('E5', 'Propiedad')
				->setCellValue('F5', 'Propietario')
				->setCellValue('G5', 'Tenencia')
				->setCellValue('H5', 'Estado')
				->setCellValue('I5', 'Fecha Tributaria')
				->setCellValue('J5', 'UF')
				->setCellValue('K5', 'Valor Tributario $')
				->setCellValue('L5', 'Valor Tributario UF')
			    ->setCellValue('M5', 'Fecha Tasacion')
				->setCellValue('N5', 'UF')
				->setCellValue('O5', 'Valor Tasacion $')
				->setCellValue('P5', 'Valor Tasacion UF')
				->setCellValue('Q5', 'Fecha Compra')
				->setCellValue('R5', 'UF')
			    ->setCellValue('S5', 'Valor Compra $')
				->setCellValue('T5', 'Valor Compra UF')
				->setCellValue('U5', 'Fecha Comercial')
				->setCellValue('V5', 'UF')
				->setCellValue('W5', 'Valor Comercial $')
				->setCellValue('X5', 'Valor Comercial UF');
			    
		//Configuraci�n de tipos de letra                         
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B5:X5')
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(true)        
			    ->getColor()
			    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
			    
		//fondo a celda
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B5:X5')
			    ->getFill()
			    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
			    ->getStartColor()
			    ->setARGB('&H808080');         

		$csu_ctr_arr = $this
                        ->mdl_rpt_pgg
                        ->mdl_csu_pgg($iCodPrp,$iTipPrp,$iCodPro,$iCodEst,$iCodUsu);

		$Ct = 5;		
		
		/*tama�o letra en grilla*/
		$objPHPExcel->getDefaultStyle()
			    ->getFont()                    
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(false)        
			    ->getColor();   

		foreach ($csu_ctr_arr as $arr)
		{
			$Ct = $Ct + 1;

			$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('B' . $Ct, $arr->tmp_cod_prp)
					->setCellValue('C' . $Ct, $arr->tmp_rol_prp)					
					->setCellValue('D' . $Ct, $arr->ttp_des_tip)
					->setCellValue('E' . $Ct, $arr->tmp_nom_prp)
					->setCellValue('F' . $Ct, $arr->tmp_nom_pro)
					->setCellValue('G' . $Ct, $arr->tmt_des_ten)
					->setCellValue('H' . $Ct, $arr->tep_des_est)
					->setCellValue('I' . $Ct, $arr->tmp_fec_val_trb)
					->setCellValue('J' . $Ct, $arr->tmp_uf_trb)
					->setCellValue('K' . $Ct, $arr->tmp_val_trb)
					->setCellValue('L' . $Ct, $arr->tmp_val_trb_uf)
					->setCellValue('M' . $Ct, $arr->tmp_fec_ava_fsc)
					->setCellValue('N' . $Ct, $arr->tmp_uf_fsc)
					->setCellValue('O' . $Ct, $arr->tmp_ava_fsc)
					->setCellValue('P' . $Ct, $arr->tmp_ava_fsc_uf)
					->setCellValue('Q' . $Ct, $arr->tmp_fec_val_cmp)
					->setCellValue('R' . $Ct, $arr->tmp_uf_cmp)
					->setCellValue('S' . $Ct, $arr->tmp_val_cmp)
					->setCellValue('T' . $Ct, $arr->tmp_val_cmp_uf)
					->setCellValue('U' . $Ct, $arr->tmp_fec_tas_cmr)
					->setCellValue('V' . $Ct, $arr->tmp_uf_cmr)
					->setCellValue('W' . $Ct, $arr->tmp_tas_cmr)
					->setCellValue('X' . $Ct, $arr->tmp_tas_cmr_uf);
			
			/*Centrar Celdas        
			$objPHPExcel->getActiveSheet()->getStyle('F' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objPHPExcel->getActiveSheet()->getStyle('H' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objPHPExcel->getActiveSheet()->getStyle('J' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objPHPExcel->getActiveSheet()->getStyle('L' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objPHPExcel->getActiveSheet()->getStyle('P' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);*/
		}
				      
		$objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
		//Unir celdas 
		$objPHPExcel->getActiveSheet()->mergeCells('B2:X2');
		     
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('U')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('V')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('W')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('X')->setAutoSize(true);

			    
		$objPHPExcel->getActiveSheet()->setTitle('Exportacion');
		$objPHPExcel->setActiveSheetIndex(0);         
		
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="Listado_Propiedades_GG.xls"');
		header('Cache-Control: max-age=0');
		header('Cache-Control: max-age=1');       
		
		header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
		header ('Cache-Control: cache, must-revalidate');
		header ('Pragma: public'); // HTTP/1.0

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');      
	}

	Public Function fnc_exp_det_csu_pgg()
	{
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/        
		$data = json_decode($this->input->get('jObject'), true);  						
		
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/
		$iCodPrp = $data[0];
		
		/** CABECERAS **/
		error_reporting(E_ALL);
		ini_set('display_errors', TRUE);
		ini_set('display_startup_errors', TRUE);   

		ini_set("memory_limit", "-1");
		set_time_limit(0);		
		
		//NUEVO OBJETO GENERAL
		$objPHPExcel = new PHPExcel();

		//PROPIEDADES METADATOS
		$objPHPExcel->getProperties()->setCreator("Contacar")
					     ->setLastModifiedBy("Operador de Contacar")
					     ->setTitle("Office Exportacion")
					     ->setSubject("Office Exportacion")
					     ->setDescription("Office Exportacion")
					     ->setKeywords("office 2007 openxml php")
					     ->setCategory("Office Exportacion");                                      
		
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Detalle de Contratos');        
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B2')
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(15)
			    ->setBold(true)
			    ->getColor();        

		//Unir celdas 
		$objPHPExcel->getActiveSheet()->mergeCells('B2:M2');
				
		/*Centrar Celdas*/            
		$objPHPExcel->getActiveSheet()->getStyle('B5:M5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
		$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('B5', 'Contrato')
				->setCellValue('C5', 'Fecha Ingreso')
				->setCellValue('D5', 'Fecha Inicio')
				->setCellValue('E5', 'Fecha Termino')
				->setCellValue('F5', 'Fecha Proyectada')
				->setCellValue('G5', 'Dureción Mes(es)')
				->setCellValue('H5', 'Tipo Mon. Origen')
				->setCellValue('I5', 'Fecha Tipo Cambio')
				->setCellValue('J5', 'Tipo Cambio')
				->setCellValue('K5', 'Arriendo Origen')
				->setCellValue('L5', 'Valor Arriendo')
				->setCellValue('M5', 'Reajuste Mes(es)')
				->setCellValue('N5', 'Fecha Aviso');

		//Configuraci�n de tipos de letra                         
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B5:N5')
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(true)        
			    ->getColor()
			    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
			    
		//fondo a celda
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B5:N5')
			    ->getFill()
			    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
			    ->getStartColor()
			    ->setARGB('&H808080');         

		$csu_ctr_arr = $this
                        ->mdl_rpt_pgg
                        ->mdl_csu_pgg_con($iCodPrp);

		$Ct = 5;		
		
		/*tama�o letra en grilla*/
		$objPHPExcel->getDefaultStyle()
			    ->getFont()                    
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(false)        
			    ->getColor();   

		foreach ($csu_ctr_arr as $arr)
		{
			$Ct = $Ct + 1;

			$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('B' . $Ct, $arr->tca_num_ctr)
					->setCellValue('C' . $Ct, $arr->tca_fec_ing)
					->setCellValue('D' . $Ct, $arr->tca_fec_ini)
					->setCellValue('E' . $Ct, $arr->tca_fec_ter)
					->setCellValue('F' . $Ct, $arr->tca_fec_fin)
					->setCellValue('G' . $Ct, $arr->tca_dur_ctr)
					->setCellValue('H' . $Ct, $arr->ttg_cod_mon)
					->setCellValue('I' . $Ct, $arr->tca_fec_cmb)
					->setCellValue('J' . $Ct, $arr->tca_val_cmb)
					->setCellValue('K' . $Ct, $arr->tca_arr_ori)
					->setCellValue('L' . $Ct, $arr->tca_val_arr)
					->setCellValue('M' . $Ct, $arr->tca_val_arr)
					->setCellValue('N' . $Ct, $arr->tca_fec_avs);

			/*Centrar Celdas*/        
			//$objPHPExcel->getActiveSheet()->getStyle('H' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			//$objPHPExcel->getActiveSheet()->getStyle('J' . $Ct )->getNumberFormat()->setFormatCode('#,##0;[Red]-$#,##0');
		}
		
		$Ct = $Ct + 2;

		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('B' . $Ct, 'Detalle de Documentos Impagos');        
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B' . $Ct)
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(15)
			    ->setBold(true)
			    ->getColor();

		$objPHPExcel->getActiveSheet()->mergeCells('B' . $Ct . ':N' . $Ct);

		$Ct = $Ct + 2;

		/*Centrar Celdas*/            
		$objPHPExcel->getActiveSheet()->getStyle('B' . $Ct . ':N' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
		$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('B' . $Ct, 'Contrato')
				->setCellValue('C' . $Ct, 'Tipo Movimiento')
				->setCellValue('D' . $Ct, 'Periodo')
				->setCellValue('E' . $Ct, 'Tipo Documento')
				->setCellValue('F' . $Ct, 'Numero Documento')
				->setCellValue('G' . $Ct, 'Documento Relacionado')
				->setCellValue('H' . $Ct, 'Numero Documento')
				->setCellValue('I' . $Ct, 'Moneda Origen')
				->setCellValue('J' . $Ct, 'Monto Origen')
				->setCellValue('K' . $Ct, 'Monto $')
				->setCellValue('L' . $Ct, 'Dia Pago')
				->setCellValue('M' . $Ct, 'Fecha Compromiso')
				->setCellValue('N' . $Ct, 'Fecha Pago');

		//Configuracin de tipos de letra                         
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B' . $Ct . ':N' . $Ct)
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(true)        
			    ->getColor()
			    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
			    
		//fondo a celda
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B' . $Ct . ':N' . $Ct)
			    ->getFill()
			    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
			    ->getStartColor()
			    ->setARGB('&H808080');		

				$csu_ctr_arr = $this
				->mdl_rpt_pgg
				->mdl_csu_pgg_doc($iCodPrp);

		$Ct = $Ct + 1;

		/*tama�o letra en grilla*/
		$objPHPExcel->getDefaultStyle()
				->getFont()                    
				->setName('Calibri')
				->setSize(8)
				->setBold(false)        
				->getColor();   

		foreach ($csu_ctr_arr as $arr)
		{
			$Ct = $Ct + 1;

			$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('B' . $Ct, $arr->tca_num_ctr)
					->setCellValue('C' . $Ct, $arr->trf_tip_cta)
					->setCellValue('D' . $Ct, $arr->tcp_per_ctr)
					->setCellValue('E' . $Ct, $arr->ttc_des_doc)
					->setCellValue('F' . $Ct, $arr->tdp_num_doc)
					->setCellValue('G' . $Ct, $arr->ttc_des_ref)
					->setCellValue('H' . $Ct, $arr->tdp_num_ref)
					->setCellValue('I' . $Ct, $arr->ttg_cod_mon)
					->setCellValue('J' . $Ct, $arr->tdp_cgo_ori)
					->setCellValue('K' . $Ct, $arr->tdp_mto_cgo)
					->setCellValue('L' . $Ct, $arr->tca_dia_pgo)
					->setCellValue('M' . $Ct, $arr->tdp_fec_pgo)
					->setCellValue('N' . $Ct, $arr->tdp_fec_mvt);

			/*Centrar Celdas*/        
			//$objPHPExcel->getActiveSheet()->getStyle('H' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			//$objPHPExcel->getActiveSheet()->getStyle('J' . $Ct )->getNumberFormat()->setFormatCode('#,##0;[Red]-$#,##0');
		}				

		$objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
		     
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);

		$objPHPExcel->getActiveSheet()->setTitle('Detalle');
		$objPHPExcel->setActiveSheetIndex(0);
		
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="Listado_Detalle_PGG.xls"');
		header('Cache-Control: max-age=0');
		header('Cache-Control: max-age=1');       
		
		header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
		header ('Cache-Control: cache, must-revalidate');
		header ('Pragma: public'); // HTTP/1.0

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');
	}

	Public Function fnc_csu_pad()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  
		
		ini_set("memory_limit", "-1");
		set_time_limit(0);

		/*[AUT-20180110 : Parametros de Entrada desde ExtJS]*/
		$iCodPrp = $data[0];
		$iCodPro = $data[1];
		$iCodSdp = $data[2];
		$iCodEst = $data[3];
		$iPenCon = $data[4];
		
		$sStart = isset($_POST['start'])?$_POST['start']:0; //posición a iniciar
        $sLimit = isset($_POST['limit'])?$_POST['limit']:50; //número de registros a mostrar 
		
		/*[AUT-20180110 : Reemplazo de apóstrofe para parámetros de Entrada desde ExtJS]*/
		$iCodPrp = str_replace("'", "´", $iCodPrp);
		$iCodPro = str_replace("'", "´", $iCodPro);
		$iCodSdp = str_replace("'", "´", $iCodSdp);
		$iCodEst = str_replace("'", "´", $iCodEst);
		$iPenCon = str_replace("'", "´", $iPenCon);

		/*[AUT-20180110 : Formación de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim(strtoupper($iCodPrp));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodPro));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iCodSdp)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iCodEst)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iPenCon)) . "'";

		$iPrm = $iPrm . "   , " . trim($sStart);
        $iPrm = $iPrm . "   , " . trim($sLimit);
		
		
		/*[AUT-20180110 : Llamada al Servicio MySQL]*/	
		$sSql = "svc_csu_btc_pad";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		$totalCount = 0;
		foreach ($query->result() as $row)
		{
			$data[] = $row;

			$totalCount = $row->totalCount;
		}

		echo json_encode(
			    array(
			      'success'  => true,
				  'total'   => $totalCount,
			      'data'     => $data                     
			    )
		);  
	}
	
	Public Function fnc_cmb_est_prp()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  
		
		ini_set("memory_limit", "-1");
		set_time_limit(0);

		/*[AUT-20180110 : Llamada al Servicio MySQL]*/	
		$sSql = "svc_cmb_est_prp";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
	 
		$query = $this->db->query($sExe);

		$data = array();
		$totalCount = 0;
		foreach ($query->result() as $row)
		{
			$data[] = $row;

			$totalCount = $row->totalCount;
		}

		echo json_encode(
			    array(
			      'success'  => true,
				  'total'   => $totalCount,
			      'data'     => $data                     
			    )
		);  
	}

	Public Function fnc_exp_csu_pad()
	{        
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/        
		$data = json_decode($this->input->get('jObject'), true);  						
		
		/*[AUT-20180110 : Parametros de Entrada desde ExtJS]*/
		$iCodPrp = $data[0];
		$iCodPro = $data[1];
		$iCodSdp = $data[2];
		$iCodEst = $data[3];
		$iPenCon = $data[4];
		
		/** CABECERAS **/
		error_reporting(E_ALL);
		ini_set('display_errors', TRUE);
		ini_set('display_startup_errors', TRUE);   

		ini_set("memory_limit", "-1");
		set_time_limit(0);		
		
		//NUEVO OBJETO GENERAL
		$objPHPExcel = new PHPExcel();

		//PROPIEDADES METADATOS
		$objPHPExcel->getProperties()->setCreator("Contacar")
					     ->setLastModifiedBy("Operador de Contacar")
					     ->setTitle("Office Exportacion")
					     ->setSubject("Office Exportacion")
					     ->setDescription("Office Exportacion")
					     ->setKeywords("office 2007 openxml php")
					     ->setCategory("Office Exportacion");                                      
		
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Propiedades');
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B2')
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(15)
			    ->setBold(true)
			    ->getColor();        
		       
		/*Centrar Celdas*/            
		$objPHPExcel->getActiveSheet()->getStyle('B5:H5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
		$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('B5', 'Código')
			    ->setCellValue('C5', 'ROL')
			    ->setCellValue('D5', 'Tipo Propiedad')
				->setCellValue('E5', 'Edificio')
			    ->setCellValue('F5', 'Dirección')
			    ->setCellValue('G5', 'Tenencia')
			    ->setCellValue('H5', 'Estado')
				->setCellValue('I5', 'Estado Contribucion');

		if ($iPenCon == 'T')
		{
			$objPHPExcel->setActiveSheetIndex(0)				
				->setCellValue('J5', 'Situacion actual de la Propiedad')
				->setCellValue('K5', 'Fecha Tas. Tributaria')
				->setCellValue('L5', 'Valor Tas. Tributaria')
				->setCellValue('M5', 'Fecha Avaluo Fiscal')
				->setCellValue('N5', 'Valor Avaluo Fiscal')
				->setCellValue('O5', 'Fecha Compra')
				->setCellValue('P5', 'Valor Compra')
				->setCellValue('Q5', 'Fecha Tas. Comercial')
				->setCellValue('R5', 'Valor Tas. Comercial');
			
			$CanCol = 'S5';
		}
		else
		{
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('J5', 'Fecha Vencimiento')
				->setCellValue('K5', 'Valor Contribucion')
				->setCellValue('L5', 'Situacion actual de la Propiedad')
				->setCellValue('M5', 'Fecha Tas. Tributaria')
				->setCellValue('N5', 'Valor Tas. Tributaria')
				->setCellValue('O5', 'Fecha Avaluo Fiscal')
				->setCellValue('P5', 'Valor Avaluo Fiscal')
				->setCellValue('Q5', 'Fecha Compra')
				->setCellValue('R5', 'Valor Compra')
				->setCellValue('S5', 'Fecha Tas. Comercial')
				->setCellValue('T5', 'Valor Tas. Comercial');
			
			$CanCol = 'T5';
		}		
			    
		//Configuraci�n de tipos de letra                         
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B5:' . $CanCol)
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(true)        
			    ->getColor()
			    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
			    
		//fondo a celda
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B5:' . $CanCol)
			    ->getFill()
			    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
			    ->getStartColor()
			    ->setARGB('&H808080');         

		$csu_ctr_arr = $this
                        ->mdl_rpt_pgg
                        ->mdl_csu_pad($iCodPrp,$iCodPro,$iCodSdp,$iCodEst,$iPenCon);

		$Ct = 5;		
		
		/*tama�o letra en grilla*/
		$objPHPExcel->getDefaultStyle()
			    ->getFont()                    
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(false)        
			    ->getColor();   

		foreach ($csu_ctr_arr as $arr)
		{
			$Ct = $Ct + 1;

			if ($arr->tca_num_ctr == 0)
			{
				$est_num_ctr = 'DISPONIBLE';
			}
			else
			{
				$est_num_ctr = 'N° de Contrato:' . $arr->tca_num_ctr;
			}

			if ($arr->tcp_est_ven == 'V')
			{
				$est_est_ven = 'VENCIDA';
			}
			elseif ($arr->tcp_est_ven == 'P')
			{
				$est_est_ven = 'PAGADA';
			}
			else
			{
				$est_est_ven = 'S/D';
			}

			$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('B' . $Ct, $arr->tmp_cod_prp)
					->setCellValue('C' . $Ct, $arr->tmp_rol_prp)
					->setCellValue('D' . $Ct, $arr->ttp_des_tip)					
					->setCellValue('E' . $Ct, $arr->tme_nom_edf)
					->setCellValue('F' . $Ct, $arr->tmp_dir_edf)
					->setCellValue('G' . $Ct, $arr->tmt_des_ten)
					->setCellValue('H' . $Ct, $arr->tep_des_est)
					->setCellValue('I' . $Ct, $est_est_ven);

			/*Centrar Celdas*/        
			$objPHPExcel->getActiveSheet()->getStyle('B' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objPHPExcel->getActiveSheet()->getStyle('C' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objPHPExcel->getActiveSheet()->getStyle('D' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objPHPExcel->getActiveSheet()->getStyle('G' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objPHPExcel->getActiveSheet()->getStyle('H' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objPHPExcel->getActiveSheet()->getStyle('I' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			if ($iPenCon == 'T')
			{
				$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('J' . $Ct, $est_num_ctr)
				->setCellValue('K' . $Ct, $arr->tmp_fec_val_trb)
				->setCellValue('L' . $Ct, $arr->tmp_val_trb)
				->setCellValue('M' . $Ct, $arr->tmp_fec_ava_fsc)
				->setCellValue('N' . $Ct, $arr->tmp_ava_fsc)
				->setCellValue('O' . $Ct, $arr->tmp_fec_val_cmp)
				->setCellValue('P' . $Ct, $arr->tmp_val_cmp)
				->setCellValue('Q' . $Ct, $arr->tmp_fec_tas_cmr)
				->setCellValue('R' . $Ct, $arr->tmp_tas_cmr);

				$objPHPExcel->getActiveSheet()->getStyle('K' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				$objPHPExcel->getActiveSheet()->getStyle('M' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				$objPHPExcel->getActiveSheet()->getStyle('O' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				$objPHPExcel->getActiveSheet()->getStyle('Q' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				
				$objPHPExcel->getActiveSheet()->getStyle('L' . $Ct )->getNumberFormat()->setFormatCode('#,##0;[Red]-$#,##0');
				$objPHPExcel->getActiveSheet()->getStyle('N' . $Ct )->getNumberFormat()->setFormatCode('#,##0;[Red]-$#,##0');
				$objPHPExcel->getActiveSheet()->getStyle('P' . $Ct )->getNumberFormat()->setFormatCode('#,##0;[Red]-$#,##0');
				$objPHPExcel->getActiveSheet()->getStyle('R' . $Ct )->getNumberFormat()->setFormatCode('#,##0;[Red]-$#,##0');
			}
			else
			{
				$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('J' . $Ct, $arr->tcp_fec_ven)
				->setCellValue('K' . $Ct, $arr->tcp_val_ctp)
				->setCellValue('L' . $Ct, $est_num_ctr)
				->setCellValue('M' . $Ct, $arr->tmp_fec_val_trb)
				->setCellValue('N' . $Ct, $arr->tmp_val_trb)
				->setCellValue('O' . $Ct, $arr->tmp_fec_ava_fsc)
				->setCellValue('P' . $Ct, $arr->tmp_ava_fsc)
				->setCellValue('Q' . $Ct, $arr->tmp_fec_val_cmp)
				->setCellValue('R' . $Ct, $arr->tmp_val_cmp)
				->setCellValue('S' . $Ct, $arr->tmp_fec_tas_cmr)
				->setCellValue('T' . $Ct, $arr->tmp_tas_cmr);

				$objPHPExcel->getActiveSheet()->getStyle('J' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				$objPHPExcel->getActiveSheet()->getStyle('M' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				$objPHPExcel->getActiveSheet()->getStyle('O' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				$objPHPExcel->getActiveSheet()->getStyle('Q' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				$objPHPExcel->getActiveSheet()->getStyle('S' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				
				$objPHPExcel->getActiveSheet()->getStyle('K' . $Ct )->getNumberFormat()->setFormatCode('#,##0;[Red]-$#,##0');
				$objPHPExcel->getActiveSheet()->getStyle('N' . $Ct )->getNumberFormat()->setFormatCode('#,##0;[Red]-$#,##0');
				$objPHPExcel->getActiveSheet()->getStyle('P' . $Ct )->getNumberFormat()->setFormatCode('#,##0;[Red]-$#,##0');
				$objPHPExcel->getActiveSheet()->getStyle('R' . $Ct )->getNumberFormat()->setFormatCode('#,##0;[Red]-$#,##0');
				$objPHPExcel->getActiveSheet()->getStyle('T' . $Ct )->getNumberFormat()->setFormatCode('#,##0;[Red]-$#,##0');
			}
		}
				      
		$objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
		
		//Unir celdas 
		$objPHPExcel->getActiveSheet()->mergeCells('B2:T2');
		     
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setAutoSize(true);
		
		$objPHPExcel->getActiveSheet()->setTitle('Exportacion');
		$objPHPExcel->setActiveSheetIndex(0);         
		
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="Listado_Propiedades_Estado.xls"');
		header('Cache-Control: max-age=0');
		header('Cache-Control: max-age=1');       
		
		header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
		header ('Cache-Control: cache, must-revalidate');
		header ('Pragma: public'); // HTTP/1.0

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');      
	}

	Public Function fnc_rpt_csu_pro_par()
	{   		
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  

		ini_set("memory_limit", "-1");
		set_time_limit(0);

		/*[AUT-20180110 : Parametros de Entrada desde ExtJS]*/
		$iCodPrp = $data[0];
		$iCodPro = $data[1];
		$iCodArr = $data[2];
		$iCodUsr = $data[3];
		$iCodEst = $data[4];
		$iNumCtr = $data[5];
		
		$sStart = isset($_POST['start'])?$_POST['start']:0; //posición a iniciar
        $sLimit = isset($_POST['limit'])?$_POST['limit']:50; //número de registros a mostrar 
		
		/*[AUT-20180110 : Reemplazo de apóstrofe para parámetros de Entrada desde ExtJS]*/
		$iCodPrp = str_replace("'", "´", $iCodPrp);
		$iCodPro = str_replace("'", "´", $iCodPro);
		$iCodArr = str_replace("'", "´", $iCodArr);
		$iCodUsr = str_replace("'", "´", $iCodUsr);
		$iCodEst = str_replace("'", "´", $iCodEst);
		$iNumCtr = str_replace("'", "´", $iNumCtr);

		/*[AUT-20180110 : Formación de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "     " . trim(strtoupper($iCodPrp));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodPro));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodArr));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodUsr));
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iCodEst)) . "'";
		$iPrm = $iPrm . "   , " . trim(strtoupper($iNumCtr));

		$iPrm = $iPrm . "   , " . trim($sStart);
        $iPrm = $iPrm . "   , " . trim($sLimit);
		
		/*[AUT-20180110 : Llamada al Servicio MySQL]*/	
		$sSql = "rpt_csu_pro_par";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		$totalCount = 0;
		foreach ($query->result() as $row)
		{
			$data[] = $row;

			$totalCount = $row->totalCount;
		}

		echo json_encode(
			    array(
			      'success'  => true,
				  'total'   => $totalCount,
			      'data'     => $data                     
			    )
		);
	}
	Public Function fnc_exp_csu_pro_par()
	{        
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/        
		$data = json_decode($this->input->get('jObject'), true);  						
		
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/
		$iCodPrp = $data[0];
		$iCodPro = $data[1];
		$iCodArr = $data[2];
		$iCodSdp = $data[3];
		$iCodEst = $data[4];
		$iNumCtr = $data[5];
		
		/** CABECERAS **/
		error_reporting(E_ALL);
		ini_set('display_errors', TRUE);
		ini_set('display_startup_errors', TRUE);   

		ini_set("memory_limit", "-1");
		set_time_limit(0);		
		
		//NUEVO OBJETO GENERAL
		$objPHPExcel = new PHPExcel();

		//PROPIEDADES METADATOS
		$objPHPExcel->getProperties()->setCreator("Contacar")
					     ->setLastModifiedBy("Operador de Contacar")
					     ->setTitle("Office Exportacion")
					     ->setSubject("Office Exportacion")
					     ->setDescription("Office Exportacion")
					     ->setKeywords("office 2007 openxml php")
					     ->setCategory("Office Exportacion");                                      
		
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado de Propiedades Arriendo');        
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B2')
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(15)
			    ->setBold(true)
			    ->getColor();        
		       
		/*Centrar Celdas*/            
		$objPHPExcel->getActiveSheet()->getStyle('B5:H5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
		$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('B5', 'Codigo Propiedad')
			    ->setCellValue('C5', 'ROL')
				->setCellValue('D5', 'Propietario')
				->setCellValue('E5', 'Arrendatario')
			    ->setCellValue('F5', 'N° Contrato')
				->setCellValue('G5', 'Estado')
			    ->setCellValue('H5', 'Fecha Contrato')
				->setCellValue('I5', 'Duración Mes(es)')
			    ->setCellValue('J5', 'Moneda')
				->setCellValue('K5', 'Fecha Tipo Cambio')
				->setCellValue('L5', 'Tipo Cambio')
				->setCellValue('M5', 'Arriendo Origen')
				->setCellValue('N5', 'Valor Arriendo')
				->setCellValue('O5', 'Fecha Ultimo Cambio')
				->setCellValue('P5', 'Ultimo Tipo Cambio')
				->setCellValue('Q5', 'Valor Arriendo')
				->setCellValue('R5', 'Fecha Inicio')
				->setCellValue('S5', 'Fecha Termino')
				->setCellValue('T5', 'Fecha Proyectada');
			    
		//Configuraci�n de tipos de letra                         
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B5:T5')
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(true)        
			    ->getColor()
			    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
			    
		//fondo a celda
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B5:T5')
			    ->getFill()
			    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
			    ->getStartColor()
			    ->setARGB('&H808080');         

		$csu_ctr_arr = $this
                        ->mdl_rpt_pgg
                        ->mdl_csu_par($iCodPrp,$iCodPro,$iCodArr,$iCodSdp,$iCodEst,$iNumCtr);

		$Ct = 5;		
		
		/*tama�o letra en grilla*/
		$objPHPExcel->getDefaultStyle()
			    ->getFont()                    
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(false)        
			    ->getColor();   

		foreach ($csu_ctr_arr as $arr)
		{
			$Ct = $Ct + 1;

			$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('B' . $Ct, $arr->tmp_cod_prp)
					->setCellValue('C' . $Ct, $arr->tmp_rol_prp)
					->setCellValue('D' . $Ct, $arr->tmp_nom_pro)
					->setCellValue('E' . $Ct, $arr->tma_nom_arr)					
					->setCellValue('F' . $Ct, $arr->tca_num_ctr)
					->setCellValue('G' . $Ct, $arr->tec_des_est)
					->setCellValue('H' . $Ct, $arr->tca_fec_ing)
					->setCellValue('I' . $Ct, $arr->tca_dur_ctr)
					->setCellValue('J' . $Ct, $arr->ttg_cod_mon)
					->setCellValue('K' . $Ct, $arr->tca_fec_cmb)
					->setCellValue('L' . $Ct, $arr->tca_val_cmb)
					->setCellValue('M' . $Ct, $arr->tca_arr_ori)
					->setCellValue('N' . $Ct, $arr->tca_val_arr)
					->setCellValue('O' . $Ct, $arr->tca_fec_ult)
					->setCellValue('P' . $Ct, $arr->tca_cmb_ult)
					->setCellValue('Q' . $Ct, $arr->tca_arr_ult)
					->setCellValue('R' . $Ct, $arr->tca_fec_ini)
					->setCellValue('S' . $Ct, $arr->tca_fec_ter)
					->setCellValue('T' . $Ct, $arr->tca_fec_fin);
			
			/*Centrar Celdas*/        
			$objPHPExcel->getActiveSheet()->getStyle('H' . $Ct )->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

			$objPHPExcel->getActiveSheet()->getStyle('J' . $Ct )->getNumberFormat()->setFormatCode('#,##0;[Red]-$#,##0');
		}
				      
		$objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
		//Unir celdas 
		$objPHPExcel->getActiveSheet()->mergeCells('B2:Q2');
		     
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setAutoSize(true);
			    
		$objPHPExcel->getActiveSheet()->setTitle('Exportacion');
		$objPHPExcel->setActiveSheetIndex(0);         
		
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="Listado_Propiedades_Arriendo.xls"');
		header('Cache-Control: max-age=0');
		header('Cache-Control: max-age=1');       
		
		header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
		header ('Cache-Control: cache, must-revalidate');
		header ('Pragma: public'); // HTTP/1.0

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');      
	}
}