<?php 
include 'enableCORS.php';
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Cls_rpt_sis extends CI_Controller {

	Public function __construct(){
		enableCORS(); 
		parent::__construct();
		/* CARGAMOS LIBRERIAS PARA ESTE CONTROLLER*/       
		include(dirname(__FILE__)."/../libraries/PHPExcel/Classes/PHPExcel.php");      
		$this->load->model(array('mdl_exp_exc')); 

	}

	Public Function fnc_csu_rpt_sis()
	{  
		$metodo = $this->config->item('metodo');
		$data = json_decode($this->input->$metodo('jObject'), true);  
		
		ini_set("memory_limit", "-1");
		set_time_limit(0);

		/*[AUT-20180211 : Parametros de Entrada desde ExtJS]*/
		$iFecIni = $data[0];
		$iFecFin = $data[1];
		$iLgnUsr = $data[2];
		$iIndGes = $data[3];
		$iNumCtr = $data[4];
		$iCodPro = $data[5];
		$iCodArr = $data[6];

		/*[AUT-20180211 : Reemplazo de ap�strofe para par�metros de Entrada desde ExtJS]*/
		$iFecIni = str_replace("'", "�", $iFecIni);
		$iFecFin = str_replace("'", "�", $iFecFin);
		$iLgnUsr = str_replace("'", "�", $iLgnUsr);
		$iIndGes = str_replace("'", "�", $iIndGes);
		$iNumCtr = str_replace("'", "�", $iNumCtr);
		$iCodPro = str_replace("'", "�", $iCodPro);
		$iCodArr = str_replace("'", "�", $iCodArr);

		/*[AUT-20180211 : Formaci�n de los Parametros de Entrada]*/
		$iPrm = "";
		
		$iPrm = $iPrm . "    '" . trim(strtoupper($iFecIni)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iFecFin)) . "'";
		$iPrm = $iPrm . "   ,'" . trim(strtoupper($iLgnUsr)) . "'";
		$iPrm = $iPrm . "   , " . trim(strtoupper($iIndGes));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iNumCtr));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodPro));
		$iPrm = $iPrm . "   , " . trim(strtoupper($iCodArr));

		/*[AUT-20180211 : Llamada al Servicio MySQL]*/	
		$sSql = "svc_csu_rpt_btc";
		
		$sExe = "";
		$sExe = $sExe . "Call " . $sSql;
		$sExe = $sExe . "(" . $iPrm . ")";
	 
		$query = $this->db->query($sExe);

		$data = array();
		foreach ($query->result() as $row)
		{
			$data[] = $row;
		}
		
		echo json_encode(
			    array(
			      'success'  => true,
			      'data'     => $data                     
			    )
		);  
	
	}


	
	
	Public Function fnc_exp_rpt_btc()
	{
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/        
		$data = json_decode($this->input->get('jObject'), true);  						
		
		/*[AUT-20170706 : Parametros de Entrada desde ExtJS]*/
		$iFecIni = $data[0];
		$iFecFin = $data[1];
		$iLgnUsr = $data[2];
		$iIndGes = $data[3];
		$iNumCtr = $data[4];
		$iCodPro = $data[5];
		$iCodArr = $data[6];
		
		if($iFecIni <> ""){
			$iFecIni = $iFecIni.' 00:00:00';
		}
		if($iFecFin <> ""){
			$iFecFin = $iFecFin.' 23:59:59';
		}
		
		/** CABECERAS **/
		error_reporting(E_ALL);
		ini_set('display_errors', TRUE);
		ini_set('display_startup_errors', TRUE);   

		ini_set("memory_limit", "-1");
		set_time_limit(0);		
		
		//NUEVO OBJETO GENERAL
		$objPHPExcel = new PHPExcel();
		

		//PROPIEDADES METADATOS
		$objPHPExcel->getProperties()->setCreator("Contacar")
					     ->setLastModifiedBy("Operador de Contacar")
					     ->setTitle("Office Exportacion")
					     ->setSubject("Office Exportacion")
					     ->setDescription("Office Exportacion")
					     ->setKeywords("office 2007 openxml php")
					     ->setCategory("Office Exportacion");                                      
		
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('B2', 'Listado Reporte de Bitacora de Contratos');        
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B2')
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(15)
			    ->setBold(true)
			    ->getColor();        
		       
		/*Centrar Celdas*/            
		$objPHPExcel->getActiveSheet()->getStyle('B5:F5')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                        
		$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('B5', 'N Contrato')
			    ->setCellValue('C5', 'Fecha Bitacora')
			    ->setCellValue('D5', 'Login Usuario')
			    ->setCellValue('E5', 'Indicador de Gestion')
			    ->setCellValue('F5', 'Descripcion');
			    
		//Configuraci�n de tipos de letra                         
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B5:F5')
			    ->getFont()
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(true)        
			    ->getColor()
			    ->setARGB( PHPExcel_Style_Color::COLOR_WHITE);        
			    
		//fondo a celda
		$objPHPExcel->getActiveSheet()
			    ->getStyle('B5:F5')
			    ->getFill()
			    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
			    ->getStartColor()
			    ->setARGB('&H808080');         

		$csu_rpt_btc = $this
                        ->mdl_exp_exc
                        ->mdl_csu_rpt_btc($iFecIni,$iFecFin,$iLgnUsr,$iIndGes,$iNumCtr,$iCodPro,$iCodArr);  

		$Ct = 5;		
		
		/*tama�o letra en grilla*/
		$objPHPExcel->getDefaultStyle()
			    ->getFont()                    
			    ->setName('Calibri')
			    ->setSize(8)
			    ->setBold(false)        
			    ->getColor();   
		   
		foreach ($csu_rpt_btc as $btc)
		{
			$Ct = $Ct + 1;
			
			$tbc_gst_btc = $btc->tbc_gst_btc;
			
			if($tbc_gst_btc == '1'){
				$tbc_gst_btc = "NO REQUIERE GESTION";
			}
			else if($tbc_gst_btc == '2'){
				$tbc_gst_btc = "PENDIENTE DE GESTION";
			}
			else if($tbc_gst_btc == '3'){
				$tbc_gst_btc = "GESTION REALIZADA";
			}
			else if($tbc_gst_btc == '0'){
				$tbc_gst_btc = "LOG";
			}
			
			$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('B' . $Ct, $btc->tca_num_ctr)
					->setCellValue('C' . $Ct, $btc->tbc_fec_ing)
					->setCellValue('D' . $Ct, $btc->tbc_log_usr)
					->setCellValue('E' . $Ct, $tbc_gst_btc)
					->setCellValue('F' . $Ct, $btc->tbc_des_btc);

			
			/*Centrar Celdas*/       
			$objPHPExcel->getActiveSheet()->getStyle('B' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objPHPExcel->getActiveSheet()->getStyle('C' . $Ct)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		}   
				      
		$objPHPExcel->getActiveSheet()->getRowDimension(5)->setRowHeight(12);        
		//Unir celdas 
		$objPHPExcel->getActiveSheet()->mergeCells('B2:E2');
		     
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);         
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
			    
		$objPHPExcel->getActiveSheet()->setTitle('Exportacion');
		$objPHPExcel->setActiveSheetIndex(0);         
		
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="Listado_de_Bitacoras_de_Contratos.xls"');
		header('Cache-Control: max-age=0');
		header('Cache-Control: max-age=1');       
		
		header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
		header ('Cache-Control: cache, must-revalidate');
		header ('Pragma: public'); // HTTP/1.0

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');
	}

}